/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReceivedMessages;

public final class ImmutableReceivedMessages
implements ReceivedMessages {
    private final int identifier;
    private final int maxId;

    private ImmutableReceivedMessages(int maxId) {
        this.maxId = maxId;
        this.identifier = ReceivedMessages.super.identifier();
    }

    private ImmutableReceivedMessages(Builder builder) {
        this.maxId = builder.maxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReceivedMessages.super.identifier();
    }

    private ImmutableReceivedMessages(int identifier, int maxId) {
        this.identifier = identifier;
        this.maxId = maxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    public final ImmutableReceivedMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReceivedMessages(value, this.maxId);
    }

    public final ImmutableReceivedMessages withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableReceivedMessages(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReceivedMessages && this.equalTo(0, (ImmutableReceivedMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableReceivedMessages another) {
        return this.identifier == another.identifier && this.maxId == another.maxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.maxId;
        return h;
    }

    public String toString() {
        return "ReceivedMessages{identifier=" + this.identifier + ", maxId=" + this.maxId + "}";
    }

    public static ImmutableReceivedMessages of(int maxId) {
        return new ImmutableReceivedMessages(maxId);
    }

    public static ImmutableReceivedMessages copyOf(ReceivedMessages instance) {
        if (instance instanceof ImmutableReceivedMessages) {
            return (ImmutableReceivedMessages)instance;
        }
        return ImmutableReceivedMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MAX_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int maxId;

        private Builder() {
        }

        public final Builder from(ReceivedMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReceivedMessages instance;
            long bits = 0L;
            if (object instanceof ReceivedMessages) {
                instance = (ReceivedMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReceivedMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReceivedMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build ReceivedMessages, some of required attributes are not set " + attributes;
        }
    }
}

