/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReceivedQueue;

public final class ImmutableReceivedQueue
implements ReceivedQueue {
    private final int identifier;
    private final int maxQts;

    private ImmutableReceivedQueue(int maxQts) {
        this.maxQts = maxQts;
        this.identifier = ReceivedQueue.super.identifier();
    }

    private ImmutableReceivedQueue(Builder builder) {
        this.maxQts = builder.maxQts;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReceivedQueue.super.identifier();
    }

    private ImmutableReceivedQueue(int identifier, int maxQts) {
        this.identifier = identifier;
        this.maxQts = maxQts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int maxQts() {
        return this.maxQts;
    }

    public final ImmutableReceivedQueue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReceivedQueue(value, this.maxQts);
    }

    public final ImmutableReceivedQueue withMaxQts(int value) {
        if (this.maxQts == value) {
            return this;
        }
        return new ImmutableReceivedQueue(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReceivedQueue && this.equalTo(0, (ImmutableReceivedQueue)another);
    }

    private boolean equalTo(int synthetic, ImmutableReceivedQueue another) {
        return this.identifier == another.identifier && this.maxQts == another.maxQts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.maxQts;
        return h;
    }

    public String toString() {
        return "ReceivedQueue{identifier=" + this.identifier + ", maxQts=" + this.maxQts + "}";
    }

    public static ImmutableReceivedQueue of(int maxQts) {
        return new ImmutableReceivedQueue(maxQts);
    }

    public static ImmutableReceivedQueue copyOf(ReceivedQueue instance) {
        if (instance instanceof ImmutableReceivedQueue) {
            return (ImmutableReceivedQueue)instance;
        }
        return ImmutableReceivedQueue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MAX_QTS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int maxQts;

        private Builder() {
        }

        public final Builder from(ReceivedQueue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReceivedQueue instance;
            long bits = 0L;
            if (object instanceof ReceivedQueue) {
                instance = (ReceivedQueue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxQts(instance.maxQts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder maxQts(int maxQts) {
            this.maxQts = maxQts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReceivedQueue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReceivedQueue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxQts");
            }
            return "Cannot build ReceivedQueue, some of required attributes are not set " + attributes;
        }
    }
}

