/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputDialogPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReorderPinnedDialogs;

public final class ImmutableReorderPinnedDialogs
implements ReorderPinnedDialogs {
    private final int identifier;
    private final int flags;
    private final boolean force;
    private final int folderId;
    private final List<InputDialogPeer> order;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReorderPinnedDialogs(int folderId) {
        this.folderId = folderId;
        this.order = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableReorderPinnedDialogs(Builder builder) {
        this.folderId = builder.folderId;
        this.order = ImmutableReorderPinnedDialogs.createUnmodifiableList(true, builder.order);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.forceIsSet()) {
            this.initShim.force(builder.force);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableReorderPinnedDialogs(int identifier, int flags, boolean force, int folderId, List<InputDialogPeer> order) {
        this.identifier = identifier;
        this.flags = flags;
        this.force = force;
        this.folderId = folderId;
        this.order = order;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReorderPinnedDialogs.super.identifier();
    }

    private int flagsInitialize() {
        return ReorderPinnedDialogs.super.flags();
    }

    private boolean forceInitialize() {
        return ReorderPinnedDialogs.super.force();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean force() {
        InitShim shim = this.initShim;
        return shim != null ? shim.force() : this.force;
    }

    @Override
    public int folderId() {
        return this.folderId;
    }

    @Override
    public List<InputDialogPeer> order() {
        return this.order;
    }

    public final ImmutableReorderPinnedDialogs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReorderPinnedDialogs(value, this.flags, this.force, this.folderId, this.order);
    }

    public final ImmutableReorderPinnedDialogs withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableReorderPinnedDialogs(this.identifier, value, this.force, this.folderId, this.order);
    }

    public final ImmutableReorderPinnedDialogs withForce(boolean value) {
        if (this.force == value) {
            return this;
        }
        return new ImmutableReorderPinnedDialogs(this.identifier, this.flags, value, this.folderId, this.order);
    }

    public final ImmutableReorderPinnedDialogs withFolderId(int value) {
        if (this.folderId == value) {
            return this;
        }
        return new ImmutableReorderPinnedDialogs(this.identifier, this.flags, this.force, value, this.order);
    }

    public final ImmutableReorderPinnedDialogs withOrder(InputDialogPeer ... elements) {
        List<InputDialogPeer> newValue = ImmutableReorderPinnedDialogs.createUnmodifiableList(false, ImmutableReorderPinnedDialogs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReorderPinnedDialogs(this.identifier, this.flags, this.force, this.folderId, newValue);
    }

    public final ImmutableReorderPinnedDialogs withOrder(Iterable<? extends InputDialogPeer> elements) {
        if (this.order == elements) {
            return this;
        }
        List<InputDialogPeer> newValue = ImmutableReorderPinnedDialogs.createUnmodifiableList(false, ImmutableReorderPinnedDialogs.createSafeList(elements, true, false));
        return new ImmutableReorderPinnedDialogs(this.identifier, this.flags, this.force, this.folderId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReorderPinnedDialogs && this.equalTo(0, (ImmutableReorderPinnedDialogs)another);
    }

    private boolean equalTo(int synthetic, ImmutableReorderPinnedDialogs another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.force == another.force && this.folderId == another.folderId && this.order.equals(another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.force);
        h += (h << 5) + this.folderId;
        h += (h << 5) + this.order.hashCode();
        return h;
    }

    public String toString() {
        return "ReorderPinnedDialogs{identifier=" + this.identifier + ", flags=" + this.flags + ", force=" + this.force + ", folderId=" + this.folderId + ", order=" + this.order + "}";
    }

    public static ImmutableReorderPinnedDialogs of(int folderId) {
        return new ImmutableReorderPinnedDialogs(folderId);
    }

    public static ImmutableReorderPinnedDialogs copyOf(ReorderPinnedDialogs instance) {
        if (instance instanceof ImmutableReorderPinnedDialogs) {
            return (ImmutableReorderPinnedDialogs)instance;
        }
        return ImmutableReorderPinnedDialogs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FOLDER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_FORCE = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean force;
        private int folderId;
        private List<InputDialogPeer> order = new ArrayList<InputDialogPeer>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReorderPinnedDialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReorderPinnedDialogs) {
                instance = (ReorderPinnedDialogs)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.force(instance.force());
                this.folderId(instance.folderId());
                this.addAllOrder(instance.order());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder force(boolean force) {
            this.force = force;
            this.optBits |= 4L;
            return this;
        }

        public final Builder folderId(int folderId) {
            this.folderId = folderId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOrder(InputDialogPeer element) {
            this.order.add(Objects.requireNonNull(element, "order element"));
            return this;
        }

        public final Builder addOrder(InputDialogPeer ... elements) {
            for (InputDialogPeer element : elements) {
                this.order.add(Objects.requireNonNull(element, "order element"));
            }
            return this;
        }

        public final Builder order(Iterable<? extends InputDialogPeer> elements) {
            this.order.clear();
            return this.addAllOrder(elements);
        }

        public final Builder addAllOrder(Iterable<? extends InputDialogPeer> elements) {
            for (InputDialogPeer inputDialogPeer : elements) {
                this.order.add(Objects.requireNonNull(inputDialogPeer, "order element"));
            }
            return this;
        }

        public ImmutableReorderPinnedDialogs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReorderPinnedDialogs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean forceIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("folderId");
            }
            return "Cannot build ReorderPinnedDialogs, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte forceBuildStage = 0;
        private boolean force;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReorderPinnedDialogs.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableReorderPinnedDialogs.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean force() {
            if (this.forceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceBuildStage == 0) {
                this.forceBuildStage = (byte)-1;
                this.force = ImmutableReorderPinnedDialogs.this.forceInitialize();
                this.forceBuildStage = 1;
            }
            return this.force;
        }

        void force(boolean force) {
            this.force = force;
            this.forceBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.forceBuildStage == -1) {
                attributes.add("force");
            }
            return "Cannot build ReorderPinnedDialogs, attribute initializers form cycle " + attributes;
        }
    }
}

