/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReorderStickerSets;

public final class ImmutableReorderStickerSets
implements ReorderStickerSets {
    private final int identifier;
    private final int flags;
    private final boolean masks;
    private final boolean emojis;
    private final List<Long> order;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReorderStickerSets(Builder builder) {
        this.order = ImmutableReorderStickerSets.createUnmodifiableList(true, builder.order);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.masksIsSet()) {
            this.initShim.masks(builder.masks);
        }
        if (builder.emojisIsSet()) {
            this.initShim.emojis(builder.emojis);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.masks = this.initShim.masks();
        this.emojis = this.initShim.emojis();
        this.initShim = null;
    }

    private ImmutableReorderStickerSets(int identifier, int flags, boolean masks, boolean emojis, List<Long> order) {
        this.identifier = identifier;
        this.flags = flags;
        this.masks = masks;
        this.emojis = emojis;
        this.order = order;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReorderStickerSets.super.identifier();
    }

    private int flagsInitialize() {
        return ReorderStickerSets.super.flags();
    }

    private boolean masksInitialize() {
        return ReorderStickerSets.super.masks();
    }

    private boolean emojisInitialize() {
        return ReorderStickerSets.super.emojis();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean masks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.masks() : this.masks;
    }

    @Override
    public boolean emojis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.emojis() : this.emojis;
    }

    @Override
    public List<Long> order() {
        return this.order;
    }

    public final ImmutableReorderStickerSets withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReorderStickerSets(value, this.flags, this.masks, this.emojis, this.order);
    }

    public final ImmutableReorderStickerSets withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableReorderStickerSets(this.identifier, value, this.masks, this.emojis, this.order);
    }

    public final ImmutableReorderStickerSets withMasks(boolean value) {
        if (this.masks == value) {
            return this;
        }
        return new ImmutableReorderStickerSets(this.identifier, this.flags, value, this.emojis, this.order);
    }

    public final ImmutableReorderStickerSets withEmojis(boolean value) {
        if (this.emojis == value) {
            return this;
        }
        return new ImmutableReorderStickerSets(this.identifier, this.flags, this.masks, value, this.order);
    }

    public final ImmutableReorderStickerSets withOrder(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableReorderStickerSets.createUnmodifiableList(false, wrappedList);
        return new ImmutableReorderStickerSets(this.identifier, this.flags, this.masks, this.emojis, newValue);
    }

    public final ImmutableReorderStickerSets withOrder(Iterable<Long> elements) {
        if (this.order == elements) {
            return this;
        }
        List<Long> newValue = ImmutableReorderStickerSets.createUnmodifiableList(false, ImmutableReorderStickerSets.createSafeList(elements, true, false));
        return new ImmutableReorderStickerSets(this.identifier, this.flags, this.masks, this.emojis, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReorderStickerSets && this.equalTo(0, (ImmutableReorderStickerSets)another);
    }

    private boolean equalTo(int synthetic, ImmutableReorderStickerSets another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.masks == another.masks && this.emojis == another.emojis && this.order.equals(another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.masks);
        h += (h << 5) + Boolean.hashCode(this.emojis);
        h += (h << 5) + this.order.hashCode();
        return h;
    }

    public String toString() {
        return "ReorderStickerSets{identifier=" + this.identifier + ", flags=" + this.flags + ", masks=" + this.masks + ", emojis=" + this.emojis + ", order=" + this.order + "}";
    }

    public static ImmutableReorderStickerSets copyOf(ReorderStickerSets instance) {
        if (instance instanceof ImmutableReorderStickerSets) {
            return (ImmutableReorderStickerSets)instance;
        }
        return ImmutableReorderStickerSets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MASKS = 4L;
        private static final long OPT_BIT_EMOJIS = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean masks;
        private boolean emojis;
        private List<Long> order = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReorderStickerSets instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReorderStickerSets) {
                instance = (ReorderStickerSets)object;
                this.emojis(instance.emojis());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.masks(instance.masks());
                this.addAllOrder(instance.order());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder masks(boolean masks) {
            this.masks = masks;
            this.optBits |= 4L;
            return this;
        }

        public final Builder emojis(boolean emojis) {
            this.emojis = emojis;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addOrder(long element) {
            this.order.add(element);
            return this;
        }

        public final Builder addOrder(long ... elements) {
            for (long element : elements) {
                this.order.add(element);
            }
            return this;
        }

        public final Builder order(Iterable<Long> elements) {
            this.order.clear();
            return this.addAllOrder(elements);
        }

        public final Builder addAllOrder(Iterable<Long> elements) {
            for (Long element : elements) {
                this.order.add(Objects.requireNonNull(element, "order element"));
            }
            return this;
        }

        public ImmutableReorderStickerSets build() {
            return new ImmutableReorderStickerSets(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean masksIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean emojisIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte masksBuildStage = 0;
        private boolean masks;
        private byte emojisBuildStage = 0;
        private boolean emojis;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReorderStickerSets.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableReorderStickerSets.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean masks() {
            if (this.masksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.masksBuildStage == 0) {
                this.masksBuildStage = (byte)-1;
                this.masks = ImmutableReorderStickerSets.this.masksInitialize();
                this.masksBuildStage = 1;
            }
            return this.masks;
        }

        void masks(boolean masks) {
            this.masks = masks;
            this.masksBuildStage = 1;
        }

        boolean emojis() {
            if (this.emojisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emojisBuildStage == 0) {
                this.emojisBuildStage = (byte)-1;
                this.emojis = ImmutableReorderStickerSets.this.emojisInitialize();
                this.emojisBuildStage = 1;
            }
            return this.emojis;
        }

        void emojis(boolean emojis) {
            this.emojis = emojis;
            this.emojisBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.masksBuildStage == -1) {
                attributes.add("masks");
            }
            if (this.emojisBuildStage == -1) {
                attributes.add("emojis");
            }
            return "Cannot build ReorderStickerSets, attribute initializers form cycle " + attributes;
        }
    }
}

