/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.ReportReason;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.Report;

public final class ImmutableReport
implements Report {
    private final int identifier;
    private final InputPeer peer;
    private final List<Integer> id;
    private final ReportReason reason;
    private final String message;

    private ImmutableReport(InputPeer peer, ReportReason reason, String message) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.reason = Objects.requireNonNull(reason, "reason");
        this.message = Objects.requireNonNull(message, "message");
        this.id = Collections.emptyList();
        this.identifier = Report.super.identifier();
    }

    private ImmutableReport(Builder builder) {
        this.peer = builder.peer;
        this.id = ImmutableReport.createUnmodifiableList(true, builder.id);
        this.reason = builder.reason;
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Report.super.identifier();
    }

    private ImmutableReport(int identifier, InputPeer peer, List<Integer> id, ReportReason reason, String message) {
        this.identifier = identifier;
        this.peer = peer;
        this.id = id;
        this.reason = reason;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public List<Integer> id() {
        return this.id;
    }

    @Override
    public ReportReason reason() {
        return this.reason;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableReport withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReport(value, this.peer, this.id, this.reason, this.message);
    }

    public final ImmutableReport withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReport(this.identifier, newValue, this.id, this.reason, this.message);
    }

    public final ImmutableReport withId(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableReport.createUnmodifiableList(false, wrappedList);
        return new ImmutableReport(this.identifier, this.peer, newValue, this.reason, this.message);
    }

    public final ImmutableReport withId(Iterable<Integer> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableReport.createUnmodifiableList(false, ImmutableReport.createSafeList(elements, true, false));
        return new ImmutableReport(this.identifier, this.peer, newValue, this.reason, this.message);
    }

    public final ImmutableReport withReason(ReportReason value) {
        ReportReason newValue = Objects.requireNonNull(value, "reason");
        if (this.reason == newValue) {
            return this;
        }
        return new ImmutableReport(this.identifier, this.peer, this.id, newValue, this.message);
    }

    public final ImmutableReport withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableReport(this.identifier, this.peer, this.id, this.reason, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReport && this.equalTo(0, (ImmutableReport)another);
    }

    private boolean equalTo(int synthetic, ImmutableReport another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.id.equals(another.id) && this.reason.equals((Object)another.reason) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "Report{identifier=" + this.identifier + ", peer=" + this.peer + ", id=" + this.id + ", reason=" + this.reason + ", message=" + this.message + "}";
    }

    public static ImmutableReport of(InputPeer peer, ReportReason reason, String message) {
        return new ImmutableReport(peer, reason, message);
    }

    public static ImmutableReport copyOf(Report instance) {
        if (instance instanceof ImmutableReport) {
            return (ImmutableReport)instance;
        }
        return ImmutableReport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_REASON = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private List<Integer> id = new ArrayList<Integer>();
        private ReportReason reason;
        private String message;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Report instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Report) {
                instance = (Report)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reason(instance.reason());
                this.addAllId(instance.id());
                this.message(instance.message());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addId(int element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(int ... elements) {
            for (int element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Integer> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public final Builder reason(ReportReason reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReport(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reason");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build Report, some of required attributes are not set " + attributes;
        }
    }
}

