/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReportEncryptedSpam;

public final class ImmutableReportEncryptedSpam
implements ReportEncryptedSpam {
    private final int identifier;
    private final InputEncryptedChat peer;

    private ImmutableReportEncryptedSpam(InputEncryptedChat peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = ReportEncryptedSpam.super.identifier();
    }

    private ImmutableReportEncryptedSpam(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReportEncryptedSpam.super.identifier();
    }

    private ImmutableReportEncryptedSpam(int identifier, InputEncryptedChat peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    public final ImmutableReportEncryptedSpam withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReportEncryptedSpam(value, this.peer);
    }

    public final ImmutableReportEncryptedSpam withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReportEncryptedSpam(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportEncryptedSpam && this.equalTo(0, (ImmutableReportEncryptedSpam)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportEncryptedSpam another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ReportEncryptedSpam{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableReportEncryptedSpam of(InputEncryptedChat peer) {
        return new ImmutableReportEncryptedSpam(peer);
    }

    public static ImmutableReportEncryptedSpam copyOf(ReportEncryptedSpam instance) {
        if (instance instanceof ImmutableReportEncryptedSpam) {
            return (ImmutableReportEncryptedSpam)instance;
        }
        return ImmutableReportEncryptedSpam.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputEncryptedChat peer;

        private Builder() {
        }

        public final Builder from(ReportEncryptedSpam instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReportEncryptedSpam instance;
            long bits = 0L;
            if (object instanceof ReportEncryptedSpam) {
                instance = (ReportEncryptedSpam)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReportEncryptedSpam build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportEncryptedSpam(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ReportEncryptedSpam, some of required attributes are not set " + attributes;
        }
    }
}

