/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReportSpam;

public final class ImmutableReportSpam
implements ReportSpam {
    private final int identifier;
    private final InputPeer peer;

    private ImmutableReportSpam(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = ReportSpam.super.identifier();
    }

    private ImmutableReportSpam(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReportSpam.super.identifier();
    }

    private ImmutableReportSpam(int identifier, InputPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableReportSpam withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReportSpam(value, this.peer);
    }

    public final ImmutableReportSpam withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReportSpam(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportSpam && this.equalTo(0, (ImmutableReportSpam)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportSpam another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ReportSpam{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableReportSpam of(InputPeer peer) {
        return new ImmutableReportSpam(peer);
    }

    public static ImmutableReportSpam copyOf(ReportSpam instance) {
        if (instance instanceof ImmutableReportSpam) {
            return (ImmutableReportSpam)instance;
        }
        return ImmutableReportSpam.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(ReportSpam instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReportSpam instance;
            long bits = 0L;
            if (object instanceof ReportSpam) {
                instance = (ReportSpam)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReportSpam build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportSpam(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ReportSpam, some of required attributes are not set " + attributes;
        }
    }
}

