/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.RequestEncryption;

public final class ImmutableRequestEncryption
implements RequestEncryption {
    private final int identifier;
    private final InputUser userId;
    private final int randomId;
    private final ByteBuf gA;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRequestEncryption(InputUser userId, int randomId) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.randomId = randomId;
        this.gA = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableRequestEncryption(Builder builder) {
        this.userId = builder.userId;
        this.randomId = builder.randomId;
        this.gA = builder.gA_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableRequestEncryption(int identifier, InputUser userId, int randomId, ByteBuf gA) {
        this.identifier = identifier;
        this.userId = userId;
        this.randomId = randomId;
        this.gA = gA;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RequestEncryption.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public int randomId() {
        return this.randomId;
    }

    @Override
    public ByteBuf gA() {
        return this.gA.duplicate();
    }

    public final ImmutableRequestEncryption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRequestEncryption(value, this.userId, this.randomId, this.gA);
    }

    public final ImmutableRequestEncryption withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableRequestEncryption(this.identifier, newValue, this.randomId, this.gA);
    }

    public final ImmutableRequestEncryption withRandomId(int value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableRequestEncryption(this.identifier, this.userId, value, this.gA);
    }

    public ImmutableRequestEncryption withGA(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gA == newValue) {
            return this;
        }
        return new ImmutableRequestEncryption(this.identifier, this.userId, this.randomId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestEncryption && this.equalTo(0, (ImmutableRequestEncryption)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestEncryption another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.randomId == another.randomId && this.gA().equals((Object)another.gA());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.randomId;
        h += (h << 5) + this.gA().hashCode();
        return h;
    }

    public String toString() {
        return "RequestEncryption{identifier=" + this.identifier + ", userId=" + this.userId + ", randomId=" + this.randomId + ", gA=" + ByteBufUtil.hexDump((ByteBuf)this.gA) + "}";
    }

    public static ImmutableRequestEncryption of(InputUser userId, int randomId) {
        return new ImmutableRequestEncryption(userId, randomId);
    }

    public static ImmutableRequestEncryption copyOf(RequestEncryption instance) {
        if (instance instanceof ImmutableRequestEncryption) {
            return (ImmutableRequestEncryption)instance;
        }
        return ImmutableRequestEncryption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf gA_value = null;
        private int identifier;
        private InputUser userId;
        private int randomId;

        private Builder() {
        }

        public final Builder from(RequestEncryption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RequestEncryption instance;
            long bits = 0L;
            if (object instanceof RequestEncryption) {
                instance = (RequestEncryption)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.gA(instance.gA());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(int randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder gA(ByteBuf value) {
            this.gA_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableRequestEncryption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequestEncryption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            return "Cannot build RequestEncryption, some of required attributes are not set " + attributes;
        }

        private ByteBuf gA_build() {
            return Objects.requireNonNull(this.gA_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRequestEncryption.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build RequestEncryption, attribute initializers form cycle " + attributes;
        }
    }
}

