/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.RequestSimpleWebView;

public final class ImmutableRequestSimpleWebView
implements RequestSimpleWebView {
    private final int identifier;
    private final int flags;
    private final InputUser bot;
    private final String url;
    @Nullable
    private final DataJSON themeParams;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRequestSimpleWebView(InputUser bot, String url) {
        this.bot = Objects.requireNonNull(bot, "bot");
        this.url = Objects.requireNonNull(url, "url");
        this.themeParams = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableRequestSimpleWebView(Builder builder) {
        this.bot = builder.bot;
        this.url = builder.url;
        this.themeParams = builder.themeParams;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableRequestSimpleWebView(int identifier, int flags, InputUser bot, String url, @Nullable DataJSON themeParams) {
        this.identifier = identifier;
        this.flags = flags;
        this.bot = bot;
        this.url = url;
        this.themeParams = themeParams;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RequestSimpleWebView.super.identifier();
    }

    private int flagsInitialize() {
        return RequestSimpleWebView.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public DataJSON themeParams() {
        return this.themeParams;
    }

    public final ImmutableRequestSimpleWebView withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRequestSimpleWebView(value, this.flags, this.bot, this.url, this.themeParams);
    }

    public final ImmutableRequestSimpleWebView withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableRequestSimpleWebView(this.identifier, value, this.bot, this.url, this.themeParams);
    }

    public final ImmutableRequestSimpleWebView withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableRequestSimpleWebView(this.identifier, this.flags, newValue, this.url, this.themeParams);
    }

    public final ImmutableRequestSimpleWebView withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableRequestSimpleWebView(this.identifier, this.flags, this.bot, newValue, this.themeParams);
    }

    public final ImmutableRequestSimpleWebView withThemeParams(@Nullable DataJSON value) {
        if (this.themeParams == value) {
            return this;
        }
        return new ImmutableRequestSimpleWebView(this.identifier, this.flags, this.bot, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestSimpleWebView && this.equalTo(0, (ImmutableRequestSimpleWebView)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestSimpleWebView another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.bot.equals(another.bot) && this.url.equals(another.url) && Objects.equals(this.themeParams, another.themeParams);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Objects.hashCode(this.themeParams);
        return h;
    }

    public String toString() {
        return "RequestSimpleWebView{identifier=" + this.identifier + ", flags=" + this.flags + ", bot=" + this.bot + ", url=" + this.url + ", themeParams=" + this.themeParams + "}";
    }

    public static ImmutableRequestSimpleWebView of(InputUser bot, String url) {
        return new ImmutableRequestSimpleWebView(bot, url);
    }

    public static ImmutableRequestSimpleWebView copyOf(RequestSimpleWebView instance) {
        if (instance instanceof ImmutableRequestSimpleWebView) {
            return (ImmutableRequestSimpleWebView)instance;
        }
        return ImmutableRequestSimpleWebView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputUser bot;
        private String url;
        private DataJSON themeParams;

        private Builder() {
        }

        public final Builder from(RequestSimpleWebView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RequestSimpleWebView instance;
            long bits = 0L;
            if (object instanceof RequestSimpleWebView) {
                DataJSON themeParamsValue;
                instance = (RequestSimpleWebView)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((themeParamsValue = instance.themeParams()) != null) {
                    this.themeParams(themeParamsValue);
                }
                this.bot(instance.bot());
                this.url(instance.url());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder themeParams(@Nullable DataJSON themeParams) {
            this.themeParams = themeParams;
            return this;
        }

        public ImmutableRequestSimpleWebView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequestSimpleWebView(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bot");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build RequestSimpleWebView, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRequestSimpleWebView.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableRequestSimpleWebView.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build RequestSimpleWebView, attribute initializers form cycle " + attributes;
        }
    }
}

