/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.RequestUrlAuth;

public final class ImmutableRequestUrlAuth
implements RequestUrlAuth {
    private final int identifier;
    private final int flags;
    @Nullable
    private final InputPeer peer;
    @Nullable
    private final Integer msgId;
    @Nullable
    private final Integer buttonId;
    @Nullable
    private final String url;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableRequestUrlAuth INSTANCE = ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth());

    private ImmutableRequestUrlAuth() {
        this.peer = null;
        this.msgId = null;
        this.buttonId = null;
        this.url = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableRequestUrlAuth(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.buttonId = builder.buttonId;
        this.url = builder.url;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableRequestUrlAuth(int identifier, int flags, @Nullable InputPeer peer, @Nullable Integer msgId, @Nullable Integer buttonId, @Nullable String url) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.msgId = msgId;
        this.buttonId = buttonId;
        this.url = url;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RequestUrlAuth.super.identifier();
    }

    private int flagsInitialize() {
        return RequestUrlAuth.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer msgId() {
        return this.msgId;
    }

    @Override
    @Nullable
    public Integer buttonId() {
        return this.buttonId;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    public final ImmutableRequestUrlAuth withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(value, this.flags, this.peer, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableRequestUrlAuth withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(this.identifier, value, this.peer, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableRequestUrlAuth withPeer(@Nullable InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(this.identifier, this.flags, value, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableRequestUrlAuth withMsgId(@Nullable Integer value) {
        if (Objects.equals(this.msgId, value)) {
            return this;
        }
        return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(this.identifier, this.flags, this.peer, value, this.buttonId, this.url));
    }

    public final ImmutableRequestUrlAuth withButtonId(@Nullable Integer value) {
        if (Objects.equals(this.buttonId, value)) {
            return this;
        }
        return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(this.identifier, this.flags, this.peer, this.msgId, value, this.url));
    }

    public final ImmutableRequestUrlAuth withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(this.identifier, this.flags, this.peer, this.msgId, this.buttonId, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestUrlAuth && this.equalTo(0, (ImmutableRequestUrlAuth)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestUrlAuth another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.peer, another.peer) && Objects.equals(this.msgId, another.msgId) && Objects.equals(this.buttonId, another.buttonId) && Objects.equals(this.url, another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.peer);
        h += (h << 5) + Objects.hashCode(this.msgId);
        h += (h << 5) + Objects.hashCode(this.buttonId);
        h += (h << 5) + Objects.hashCode(this.url);
        return h;
    }

    public String toString() {
        return "RequestUrlAuth{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", msgId=" + this.msgId + ", buttonId=" + this.buttonId + ", url=" + this.url + "}";
    }

    public static ImmutableRequestUrlAuth of() {
        return INSTANCE;
    }

    private static ImmutableRequestUrlAuth validate(ImmutableRequestUrlAuth instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableRequestUrlAuth copyOf(RequestUrlAuth instance) {
        if (instance instanceof ImmutableRequestUrlAuth) {
            return (ImmutableRequestUrlAuth)instance;
        }
        return ImmutableRequestUrlAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputPeer peer;
        private Integer msgId;
        private Integer buttonId;
        private String url;

        private Builder() {
        }

        public final Builder from(RequestUrlAuth instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RequestUrlAuth instance;
            long bits = 0L;
            if (object instanceof RequestUrlAuth) {
                String urlValue;
                InputPeer peerValue;
                Integer msgIdValue;
                instance = (RequestUrlAuth)object;
                this.flags(instance.flags());
                Integer buttonIdValue = instance.buttonId();
                if (buttonIdValue != null) {
                    this.buttonId(buttonIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((msgIdValue = instance.msgId()) != null) {
                    this.msgId(msgIdValue);
                }
                if ((peerValue = instance.peer()) != null) {
                    this.peer(peerValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(@Nullable InputPeer peer) {
            this.peer = peer;
            return this;
        }

        public final Builder msgId(@Nullable Integer msgId) {
            this.msgId = msgId;
            return this;
        }

        public final Builder buttonId(@Nullable Integer buttonId) {
            this.buttonId = buttonId;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public ImmutableRequestUrlAuth build() {
            return ImmutableRequestUrlAuth.validate(new ImmutableRequestUrlAuth(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRequestUrlAuth.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableRequestUrlAuth.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build RequestUrlAuth, attribute initializers form cycle " + attributes;
        }
    }
}

