/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.RequestWebView;

public final class ImmutableRequestWebView
implements RequestWebView {
    private final int identifier;
    private final int flags;
    private final boolean fromBotMenu;
    private final boolean silent;
    private final InputPeer peer;
    private final InputUser bot;
    @Nullable
    private final String url;
    @Nullable
    private final String startParam;
    @Nullable
    private final DataJSON themeParams;
    @Nullable
    private final Integer replyToMsgId;
    @Nullable
    private final InputPeer sendAs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRequestWebView(InputPeer peer, InputUser bot) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.bot = Objects.requireNonNull(bot, "bot");
        this.url = null;
        this.startParam = null;
        this.themeParams = null;
        this.replyToMsgId = null;
        this.sendAs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.fromBotMenu = this.initShim.fromBotMenu();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableRequestWebView(Builder builder) {
        this.peer = builder.peer;
        this.bot = builder.bot;
        this.url = builder.url;
        this.startParam = builder.startParam;
        this.themeParams = builder.themeParams;
        this.replyToMsgId = builder.replyToMsgId;
        this.sendAs = builder.sendAs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.fromBotMenuIsSet()) {
            this.initShim.fromBotMenu(builder.fromBotMenu);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.fromBotMenu = this.initShim.fromBotMenu();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableRequestWebView(int identifier, int flags, boolean fromBotMenu, boolean silent, InputPeer peer, InputUser bot, @Nullable String url, @Nullable String startParam, @Nullable DataJSON themeParams, @Nullable Integer replyToMsgId, @Nullable InputPeer sendAs) {
        this.identifier = identifier;
        this.flags = flags;
        this.fromBotMenu = fromBotMenu;
        this.silent = silent;
        this.peer = peer;
        this.bot = bot;
        this.url = url;
        this.startParam = startParam;
        this.themeParams = themeParams;
        this.replyToMsgId = replyToMsgId;
        this.sendAs = sendAs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RequestWebView.super.identifier();
    }

    private int flagsInitialize() {
        return RequestWebView.super.flags();
    }

    private boolean fromBotMenuInitialize() {
        return RequestWebView.super.fromBotMenu();
    }

    private boolean silentInitialize() {
        return RequestWebView.super.silent();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean fromBotMenu() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fromBotMenu() : this.fromBotMenu;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public String startParam() {
        return this.startParam;
    }

    @Override
    @Nullable
    public DataJSON themeParams() {
        return this.themeParams;
    }

    @Override
    @Nullable
    public Integer replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    @Nullable
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableRequestWebView withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRequestWebView(value, this.flags, this.fromBotMenu, this.silent, this.peer, this.bot, this.url, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, value, this.fromBotMenu, this.silent, this.peer, this.bot, this.url, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withFromBotMenu(boolean value) {
        if (this.fromBotMenu == value) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, value, this.silent, this.peer, this.bot, this.url, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, value, this.peer, this.bot, this.url, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, newValue, this.bot, this.url, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, this.peer, newValue, this.url, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, this.peer, this.bot, value, this.startParam, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withStartParam(@Nullable String value) {
        if (Objects.equals(this.startParam, value)) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, this.peer, this.bot, this.url, value, this.themeParams, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withThemeParams(@Nullable DataJSON value) {
        if (this.themeParams == value) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, this.peer, this.bot, this.url, this.startParam, value, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableRequestWebView withReplyToMsgId(@Nullable Integer value) {
        if (Objects.equals(this.replyToMsgId, value)) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, this.peer, this.bot, this.url, this.startParam, this.themeParams, value, this.sendAs);
    }

    public final ImmutableRequestWebView withSendAs(@Nullable InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        return new ImmutableRequestWebView(this.identifier, this.flags, this.fromBotMenu, this.silent, this.peer, this.bot, this.url, this.startParam, this.themeParams, this.replyToMsgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestWebView && this.equalTo(0, (ImmutableRequestWebView)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestWebView another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.fromBotMenu == another.fromBotMenu && this.silent == another.silent && this.peer.equals(another.peer) && this.bot.equals(another.bot) && Objects.equals(this.url, another.url) && Objects.equals(this.startParam, another.startParam) && Objects.equals(this.themeParams, another.themeParams) && Objects.equals(this.replyToMsgId, another.replyToMsgId) && Objects.equals(this.sendAs, another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.fromBotMenu);
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.startParam);
        h += (h << 5) + Objects.hashCode(this.themeParams);
        h += (h << 5) + Objects.hashCode(this.replyToMsgId);
        h += (h << 5) + Objects.hashCode(this.sendAs);
        return h;
    }

    public String toString() {
        return "RequestWebView{identifier=" + this.identifier + ", flags=" + this.flags + ", fromBotMenu=" + this.fromBotMenu + ", silent=" + this.silent + ", peer=" + this.peer + ", bot=" + this.bot + ", url=" + this.url + ", startParam=" + this.startParam + ", themeParams=" + this.themeParams + ", replyToMsgId=" + this.replyToMsgId + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableRequestWebView of(InputPeer peer, InputUser bot) {
        return new ImmutableRequestWebView(peer, bot);
    }

    public static ImmutableRequestWebView copyOf(RequestWebView instance) {
        if (instance instanceof ImmutableRequestWebView) {
            return (ImmutableRequestWebView)instance;
        }
        return ImmutableRequestWebView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_BOT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_FROM_BOT_MENU = 4L;
        private static final long OPT_BIT_SILENT = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean fromBotMenu;
        private boolean silent;
        private InputPeer peer;
        private InputUser bot;
        private String url;
        private String startParam;
        private DataJSON themeParams;
        private Integer replyToMsgId;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RequestWebView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RequestWebView) {
                String urlValue;
                Integer replyToMsgIdValue;
                String startParamValue;
                instance = (RequestWebView)object;
                this.fromBotMenu(instance.fromBotMenu());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                DataJSON themeParamsValue = instance.themeParams();
                if (themeParamsValue != null) {
                    this.themeParams(themeParamsValue);
                }
                if ((startParamValue = instance.startParam()) != null) {
                    this.startParam(startParamValue);
                }
                this.peer(instance.peer());
                this.bot(instance.bot());
                this.flags(instance.flags());
                InputPeer sendAsValue = instance.sendAs();
                if (sendAsValue != null) {
                    this.sendAs(sendAsValue);
                }
                if ((replyToMsgIdValue = instance.replyToMsgId()) != null) {
                    this.replyToMsgId(replyToMsgIdValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder fromBotMenu(boolean fromBotMenu) {
            this.fromBotMenu = fromBotMenu;
            this.optBits |= 4L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 8L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder startParam(@Nullable String startParam) {
            this.startParam = startParam;
            return this;
        }

        public final Builder themeParams(@Nullable DataJSON themeParams) {
            this.themeParams = themeParams;
            return this;
        }

        public final Builder replyToMsgId(@Nullable Integer replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            return this;
        }

        public final Builder sendAs(@Nullable InputPeer sendAs) {
            this.sendAs = sendAs;
            return this;
        }

        public ImmutableRequestWebView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequestWebView(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean fromBotMenuIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bot");
            }
            return "Cannot build RequestWebView, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte fromBotMenuBuildStage = 0;
        private boolean fromBotMenu;
        private byte silentBuildStage = 0;
        private boolean silent;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRequestWebView.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableRequestWebView.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean fromBotMenu() {
            if (this.fromBotMenuBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromBotMenuBuildStage == 0) {
                this.fromBotMenuBuildStage = (byte)-1;
                this.fromBotMenu = ImmutableRequestWebView.this.fromBotMenuInitialize();
                this.fromBotMenuBuildStage = 1;
            }
            return this.fromBotMenu;
        }

        void fromBotMenu(boolean fromBotMenu) {
            this.fromBotMenu = fromBotMenu;
            this.fromBotMenuBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableRequestWebView.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.fromBotMenuBuildStage == -1) {
                attributes.add("fromBotMenu");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            return "Cannot build RequestWebView, attribute initializers form cycle " + attributes;
        }
    }
}

