/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SaveDefaultSendAs;

public final class ImmutableSaveDefaultSendAs
implements SaveDefaultSendAs {
    private final int identifier;
    private final InputPeer peer;
    private final InputPeer sendAs;

    private ImmutableSaveDefaultSendAs(InputPeer peer, InputPeer sendAs) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.sendAs = Objects.requireNonNull(sendAs, "sendAs");
        this.identifier = SaveDefaultSendAs.super.identifier();
    }

    private ImmutableSaveDefaultSendAs(Builder builder) {
        this.peer = builder.peer;
        this.sendAs = builder.sendAs;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveDefaultSendAs.super.identifier();
    }

    private ImmutableSaveDefaultSendAs(int identifier, InputPeer peer, InputPeer sendAs) {
        this.identifier = identifier;
        this.peer = peer;
        this.sendAs = sendAs;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableSaveDefaultSendAs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveDefaultSendAs(value, this.peer, this.sendAs);
    }

    public final ImmutableSaveDefaultSendAs withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSaveDefaultSendAs(this.identifier, newValue, this.sendAs);
    }

    public final ImmutableSaveDefaultSendAs withSendAs(InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "sendAs");
        return new ImmutableSaveDefaultSendAs(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveDefaultSendAs && this.equalTo(0, (ImmutableSaveDefaultSendAs)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveDefaultSendAs another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.sendAs.equals(another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.sendAs.hashCode();
        return h;
    }

    public String toString() {
        return "SaveDefaultSendAs{identifier=" + this.identifier + ", peer=" + this.peer + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableSaveDefaultSendAs of(InputPeer peer, InputPeer sendAs) {
        return new ImmutableSaveDefaultSendAs(peer, sendAs);
    }

    public static ImmutableSaveDefaultSendAs copyOf(SaveDefaultSendAs instance) {
        if (instance instanceof ImmutableSaveDefaultSendAs) {
            return (ImmutableSaveDefaultSendAs)instance;
        }
        return ImmutableSaveDefaultSendAs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_SEND_AS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(SaveDefaultSendAs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveDefaultSendAs instance;
            long bits = 0L;
            if (object instanceof SaveDefaultSendAs) {
                instance = (SaveDefaultSendAs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.sendAs(instance.sendAs());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sendAs(InputPeer sendAs) {
            this.sendAs = Objects.requireNonNull(sendAs, "sendAs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveDefaultSendAs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveDefaultSendAs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sendAs");
            }
            return "Cannot build SaveDefaultSendAs, some of required attributes are not set " + attributes;
        }
    }
}

