/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SaveGif;

public final class ImmutableSaveGif
implements SaveGif {
    private final int identifier;
    private final InputDocument id;
    private final boolean unsave;

    private ImmutableSaveGif(InputDocument id, boolean unsave) {
        this.id = Objects.requireNonNull(id, "id");
        this.unsave = unsave;
        this.identifier = SaveGif.super.identifier();
    }

    private ImmutableSaveGif(Builder builder) {
        this.id = builder.id;
        this.unsave = builder.unsave;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveGif.super.identifier();
    }

    private ImmutableSaveGif(int identifier, InputDocument id, boolean unsave) {
        this.identifier = identifier;
        this.id = id;
        this.unsave = unsave;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputDocument id() {
        return this.id;
    }

    @Override
    public boolean unsave() {
        return this.unsave;
    }

    public final ImmutableSaveGif withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveGif(value, this.id, this.unsave);
    }

    public final ImmutableSaveGif withId(InputDocument value) {
        if (this.id == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "id");
        return new ImmutableSaveGif(this.identifier, newValue, this.unsave);
    }

    public final ImmutableSaveGif withUnsave(boolean value) {
        if (this.unsave == value) {
            return this;
        }
        return new ImmutableSaveGif(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveGif && this.equalTo(0, (ImmutableSaveGif)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveGif another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.unsave == another.unsave;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Boolean.hashCode(this.unsave);
        return h;
    }

    public String toString() {
        return "SaveGif{identifier=" + this.identifier + ", id=" + this.id + ", unsave=" + this.unsave + "}";
    }

    public static ImmutableSaveGif of(InputDocument id, boolean unsave) {
        return new ImmutableSaveGif(id, unsave);
    }

    public static ImmutableSaveGif copyOf(SaveGif instance) {
        if (instance instanceof ImmutableSaveGif) {
            return (ImmutableSaveGif)instance;
        }
        return ImmutableSaveGif.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_UNSAVE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputDocument id;
        private boolean unsave;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SaveGif instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SaveGif) {
                instance = (SaveGif)object;
                this.unsave(instance.unsave());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputDocument id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unsave(boolean unsave) {
            this.unsave = unsave;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveGif build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveGif(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unsave");
            }
            return "Cannot build SaveGif, some of required attributes are not set " + attributes;
        }
    }
}

