/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SaveRecentSticker;

public final class ImmutableSaveRecentSticker
implements SaveRecentSticker {
    private final int identifier;
    private final int flags;
    private final boolean attached;
    private final InputDocument id;
    private final boolean unsave;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSaveRecentSticker(InputDocument id, boolean unsave) {
        this.id = Objects.requireNonNull(id, "id");
        this.unsave = unsave;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.attached = this.initShim.attached();
        this.initShim = null;
    }

    private ImmutableSaveRecentSticker(Builder builder) {
        this.id = builder.id;
        this.unsave = builder.unsave;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.attachedIsSet()) {
            this.initShim.attached(builder.attached);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.attached = this.initShim.attached();
        this.initShim = null;
    }

    private ImmutableSaveRecentSticker(int identifier, int flags, boolean attached, InputDocument id, boolean unsave) {
        this.identifier = identifier;
        this.flags = flags;
        this.attached = attached;
        this.id = id;
        this.unsave = unsave;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SaveRecentSticker.super.identifier();
    }

    private int flagsInitialize() {
        return SaveRecentSticker.super.flags();
    }

    private boolean attachedInitialize() {
        return SaveRecentSticker.super.attached();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean attached() {
        InitShim shim = this.initShim;
        return shim != null ? shim.attached() : this.attached;
    }

    @Override
    public InputDocument id() {
        return this.id;
    }

    @Override
    public boolean unsave() {
        return this.unsave;
    }

    public final ImmutableSaveRecentSticker withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveRecentSticker(value, this.flags, this.attached, this.id, this.unsave);
    }

    public final ImmutableSaveRecentSticker withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSaveRecentSticker(this.identifier, value, this.attached, this.id, this.unsave);
    }

    public final ImmutableSaveRecentSticker withAttached(boolean value) {
        if (this.attached == value) {
            return this;
        }
        return new ImmutableSaveRecentSticker(this.identifier, this.flags, value, this.id, this.unsave);
    }

    public final ImmutableSaveRecentSticker withId(InputDocument value) {
        if (this.id == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "id");
        return new ImmutableSaveRecentSticker(this.identifier, this.flags, this.attached, newValue, this.unsave);
    }

    public final ImmutableSaveRecentSticker withUnsave(boolean value) {
        if (this.unsave == value) {
            return this;
        }
        return new ImmutableSaveRecentSticker(this.identifier, this.flags, this.attached, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveRecentSticker && this.equalTo(0, (ImmutableSaveRecentSticker)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveRecentSticker another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.attached == another.attached && this.id.equals(another.id) && this.unsave == another.unsave;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.attached);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Boolean.hashCode(this.unsave);
        return h;
    }

    public String toString() {
        return "SaveRecentSticker{identifier=" + this.identifier + ", flags=" + this.flags + ", attached=" + this.attached + ", id=" + this.id + ", unsave=" + this.unsave + "}";
    }

    public static ImmutableSaveRecentSticker of(InputDocument id, boolean unsave) {
        return new ImmutableSaveRecentSticker(id, unsave);
    }

    public static ImmutableSaveRecentSticker copyOf(SaveRecentSticker instance) {
        if (instance instanceof ImmutableSaveRecentSticker) {
            return (ImmutableSaveRecentSticker)instance;
        }
        return ImmutableSaveRecentSticker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_UNSAVE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ATTACHED = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean attached;
        private InputDocument id;
        private boolean unsave;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SaveRecentSticker instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SaveRecentSticker) {
                instance = (SaveRecentSticker)object;
                this.flags(instance.flags());
                this.attached(instance.attached());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.unsave(instance.unsave());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder attached(boolean attached) {
            this.attached = attached;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(InputDocument id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unsave(boolean unsave) {
            this.unsave = unsave;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveRecentSticker build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveRecentSticker(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean attachedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unsave");
            }
            return "Cannot build SaveRecentSticker, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte attachedBuildStage = 0;
        private boolean attached;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSaveRecentSticker.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSaveRecentSticker.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean attached() {
            if (this.attachedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachedBuildStage == 0) {
                this.attachedBuildStage = (byte)-1;
                this.attached = ImmutableSaveRecentSticker.this.attachedInitialize();
                this.attachedBuildStage = 1;
            }
            return this.attached;
        }

        void attached(boolean attached) {
            this.attached = attached;
            this.attachedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.attachedBuildStage == -1) {
                attributes.add("attached");
            }
            return "Cannot build SaveRecentSticker, attribute initializers form cycle " + attributes;
        }
    }
}

