/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.Search;

public final class ImmutableSearch
implements Search {
    private final int identifier;
    private final int flags;
    private final InputPeer peer;
    private final String q;
    @Nullable
    private final InputPeer fromId;
    @Nullable
    private final Integer topMsgId;
    private final MessagesFilter filter;
    private final int minDate;
    private final int maxDate;
    private final int offsetId;
    private final int addOffset;
    private final int limit;
    private final int maxId;
    private final int minId;
    private final long hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSearch(InputPeer peer, String q, MessagesFilter filter, int minDate, int maxDate, int offsetId, int addOffset, int limit, int maxId, int minId, long hash) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.q = Objects.requireNonNull(q, "q");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.offsetId = offsetId;
        this.addOffset = addOffset;
        this.limit = limit;
        this.maxId = maxId;
        this.minId = minId;
        this.hash = hash;
        this.fromId = null;
        this.topMsgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSearch(Builder builder) {
        this.peer = builder.peer;
        this.q = builder.q;
        this.fromId = builder.fromId;
        this.topMsgId = builder.topMsgId;
        this.filter = builder.filter;
        this.minDate = builder.minDate;
        this.maxDate = builder.maxDate;
        this.offsetId = builder.offsetId;
        this.addOffset = builder.addOffset;
        this.limit = builder.limit;
        this.maxId = builder.maxId;
        this.minId = builder.minId;
        this.hash = builder.hash;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSearch(int identifier, int flags, InputPeer peer, String q, @Nullable InputPeer fromId, @Nullable Integer topMsgId, MessagesFilter filter, int minDate, int maxDate, int offsetId, int addOffset, int limit, int maxId, int minId, long hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.q = q;
        this.fromId = fromId;
        this.topMsgId = topMsgId;
        this.filter = filter;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.offsetId = offsetId;
        this.addOffset = addOffset;
        this.limit = limit;
        this.maxId = maxId;
        this.minId = minId;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Search.super.identifier();
    }

    private int flagsInitialize() {
        return Search.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    @Nullable
    public InputPeer fromId() {
        return this.fromId;
    }

    @Override
    @Nullable
    public Integer topMsgId() {
        return this.topMsgId;
    }

    @Override
    public MessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int minDate() {
        return this.minDate;
    }

    @Override
    public int maxDate() {
        return this.maxDate;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int addOffset() {
        return this.addOffset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    public int minId() {
        return this.minId;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableSearch withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearch(value, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, value, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSearch(this.identifier, this.flags, newValue, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, newValue, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withFromId(@Nullable InputPeer value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, value, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withTopMsgId(@Nullable Integer value) {
        if (Objects.equals(this.topMsgId, value)) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, value, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withFilter(MessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        MessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, newValue, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withMinDate(int value) {
        if (this.minDate == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, value, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withMaxDate(int value) {
        if (this.maxDate == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, value, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, value, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withAddOffset(int value) {
        if (this.addOffset == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, value, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, value, this.maxId, this.minId, this.hash);
    }

    public final ImmutableSearch withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, value, this.minId, this.hash);
    }

    public final ImmutableSearch withMinId(int value) {
        if (this.minId == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, value, this.hash);
    }

    public final ImmutableSearch withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.flags, this.peer, this.q, this.fromId, this.topMsgId, this.filter, this.minDate, this.maxDate, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearch && this.equalTo(0, (ImmutableSearch)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearch another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.peer.equals(another.peer) && this.q.equals(another.q) && Objects.equals(this.fromId, another.fromId) && Objects.equals(this.topMsgId, another.topMsgId) && this.filter.equals(another.filter) && this.minDate == another.minDate && this.maxDate == another.maxDate && this.offsetId == another.offsetId && this.addOffset == another.addOffset && this.limit == another.limit && this.maxId == another.maxId && this.minId == another.minId && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.q.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromId);
        h += (h << 5) + Objects.hashCode(this.topMsgId);
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.minDate;
        h += (h << 5) + this.maxDate;
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.addOffset;
        h += (h << 5) + this.limit;
        h += (h << 5) + this.maxId;
        h += (h << 5) + this.minId;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "Search{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", q=" + this.q + ", fromId=" + this.fromId + ", topMsgId=" + this.topMsgId + ", filter=" + this.filter + ", minDate=" + this.minDate + ", maxDate=" + this.maxDate + ", offsetId=" + this.offsetId + ", addOffset=" + this.addOffset + ", limit=" + this.limit + ", maxId=" + this.maxId + ", minId=" + this.minId + ", hash=" + this.hash + "}";
    }

    public static ImmutableSearch of(InputPeer peer, String q, MessagesFilter filter, int minDate, int maxDate, int offsetId, int addOffset, int limit, int maxId, int minId, long hash) {
        return new ImmutableSearch(peer, q, filter, minDate, maxDate, offsetId, addOffset, limit, maxId, minId, hash);
    }

    public static ImmutableSearch copyOf(Search instance) {
        if (instance instanceof ImmutableSearch) {
            return (ImmutableSearch)instance;
        }
        return ImmutableSearch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_Q = 2L;
        private static final long INIT_BIT_FILTER = 4L;
        private static final long INIT_BIT_MIN_DATE = 8L;
        private static final long INIT_BIT_MAX_DATE = 16L;
        private static final long INIT_BIT_OFFSET_ID = 32L;
        private static final long INIT_BIT_ADD_OFFSET = 64L;
        private static final long INIT_BIT_LIMIT = 128L;
        private static final long INIT_BIT_MAX_ID = 256L;
        private static final long INIT_BIT_MIN_ID = 512L;
        private static final long INIT_BIT_HASH = 1024L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 2047L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputPeer peer;
        private String q;
        private InputPeer fromId;
        private Integer topMsgId;
        private MessagesFilter filter;
        private int minDate;
        private int maxDate;
        private int offsetId;
        private int addOffset;
        private int limit;
        private int maxId;
        private int minId;
        private long hash;

        private Builder() {
        }

        public final Builder from(Search instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Search instance;
            long bits = 0L;
            if (object instanceof Search) {
                InputPeer fromIdValue;
                instance = (Search)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.minDate(instance.minDate());
                this.flags(instance.flags());
                Integer topMsgIdValue = instance.topMsgId();
                if (topMsgIdValue != null) {
                    this.topMsgId(topMsgIdValue);
                }
                if ((fromIdValue = instance.fromId()) != null) {
                    this.fromId(fromIdValue);
                }
                this.filter(instance.filter());
                this.q(instance.q());
                this.maxId(instance.maxId());
                this.peer(instance.peer());
                this.limit(instance.limit());
                this.maxDate(instance.maxDate());
                this.addOffset(instance.addOffset());
                this.minId(instance.minId());
                this.offsetId(instance.offsetId());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fromId(@Nullable InputPeer fromId) {
            this.fromId = fromId;
            return this;
        }

        public final Builder topMsgId(@Nullable Integer topMsgId) {
            this.topMsgId = topMsgId;
            return this;
        }

        public final Builder filter(MessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder minDate(int minDate) {
            this.minDate = minDate;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder maxDate(int maxDate) {
            this.maxDate = maxDate;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addOffset(int addOffset) {
            this.addOffset = addOffset;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder minId(int minId) {
            this.minId = minId;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public ImmutableSearch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearch(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("q");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("minDate");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("maxDate");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("addOffset");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("minId");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build Search, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSearch.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSearch.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build Search, attribute initializers form cycle " + attributes;
        }
    }
}

