/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SearchGlobal;

public final class ImmutableSearchGlobal
implements SearchGlobal {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer folderId;
    private final String q;
    private final MessagesFilter filter;
    private final int minDate;
    private final int maxDate;
    private final int offsetRate;
    private final InputPeer offsetPeer;
    private final int offsetId;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSearchGlobal(String q, MessagesFilter filter, int minDate, int maxDate, int offsetRate, InputPeer offsetPeer, int offsetId, int limit) {
        this.q = Objects.requireNonNull(q, "q");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.offsetRate = offsetRate;
        this.offsetPeer = Objects.requireNonNull(offsetPeer, "offsetPeer");
        this.offsetId = offsetId;
        this.limit = limit;
        this.folderId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSearchGlobal(Builder builder) {
        this.folderId = builder.folderId;
        this.q = builder.q;
        this.filter = builder.filter;
        this.minDate = builder.minDate;
        this.maxDate = builder.maxDate;
        this.offsetRate = builder.offsetRate;
        this.offsetPeer = builder.offsetPeer;
        this.offsetId = builder.offsetId;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSearchGlobal(int identifier, int flags, @Nullable Integer folderId, String q, MessagesFilter filter, int minDate, int maxDate, int offsetRate, InputPeer offsetPeer, int offsetId, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.folderId = folderId;
        this.q = q;
        this.filter = filter;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.offsetRate = offsetRate;
        this.offsetPeer = offsetPeer;
        this.offsetId = offsetId;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SearchGlobal.super.identifier();
    }

    private int flagsInitialize() {
        return SearchGlobal.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    public MessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int minDate() {
        return this.minDate;
    }

    @Override
    public int maxDate() {
        return this.maxDate;
    }

    @Override
    public int offsetRate() {
        return this.offsetRate;
    }

    @Override
    public InputPeer offsetPeer() {
        return this.offsetPeer;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableSearchGlobal withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchGlobal(value, this.flags, this.folderId, this.q, this.filter, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, value, this.folderId, this.q, this.filter, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, value, this.q, this.filter, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, newValue, this.filter, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withFilter(MessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        MessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, newValue, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withMinDate(int value) {
        if (this.minDate == value) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, this.filter, value, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withMaxDate(int value) {
        if (this.maxDate == value) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, this.filter, this.minDate, value, this.offsetRate, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withOffsetRate(int value) {
        if (this.offsetRate == value) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, this.filter, this.minDate, this.maxDate, value, this.offsetPeer, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withOffsetPeer(InputPeer value) {
        if (this.offsetPeer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "offsetPeer");
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, this.filter, this.minDate, this.maxDate, this.offsetRate, newValue, this.offsetId, this.limit);
    }

    public final ImmutableSearchGlobal withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, this.filter, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, value, this.limit);
    }

    public final ImmutableSearchGlobal withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableSearchGlobal(this.identifier, this.flags, this.folderId, this.q, this.filter, this.minDate, this.maxDate, this.offsetRate, this.offsetPeer, this.offsetId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchGlobal && this.equalTo(0, (ImmutableSearchGlobal)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchGlobal another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.folderId, another.folderId) && this.q.equals(another.q) && this.filter.equals(another.filter) && this.minDate == another.minDate && this.maxDate == another.maxDate && this.offsetRate == another.offsetRate && this.offsetPeer.equals(another.offsetPeer) && this.offsetId == another.offsetId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + this.q.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.minDate;
        h += (h << 5) + this.maxDate;
        h += (h << 5) + this.offsetRate;
        h += (h << 5) + this.offsetPeer.hashCode();
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "SearchGlobal{identifier=" + this.identifier + ", flags=" + this.flags + ", folderId=" + this.folderId + ", q=" + this.q + ", filter=" + this.filter + ", minDate=" + this.minDate + ", maxDate=" + this.maxDate + ", offsetRate=" + this.offsetRate + ", offsetPeer=" + this.offsetPeer + ", offsetId=" + this.offsetId + ", limit=" + this.limit + "}";
    }

    public static ImmutableSearchGlobal of(String q, MessagesFilter filter, int minDate, int maxDate, int offsetRate, InputPeer offsetPeer, int offsetId, int limit) {
        return new ImmutableSearchGlobal(q, filter, minDate, maxDate, offsetRate, offsetPeer, offsetId, limit);
    }

    public static ImmutableSearchGlobal copyOf(SearchGlobal instance) {
        if (instance instanceof ImmutableSearchGlobal) {
            return (ImmutableSearchGlobal)instance;
        }
        return ImmutableSearchGlobal.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_Q = 1L;
        private static final long INIT_BIT_FILTER = 2L;
        private static final long INIT_BIT_MIN_DATE = 4L;
        private static final long INIT_BIT_MAX_DATE = 8L;
        private static final long INIT_BIT_OFFSET_RATE = 16L;
        private static final long INIT_BIT_OFFSET_PEER = 32L;
        private static final long INIT_BIT_OFFSET_ID = 64L;
        private static final long INIT_BIT_LIMIT = 128L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 255L;
        private long optBits;
        private int identifier;
        private int flags;
        private Integer folderId;
        private String q;
        private MessagesFilter filter;
        private int minDate;
        private int maxDate;
        private int offsetRate;
        private InputPeer offsetPeer;
        private int offsetId;
        private int limit;

        private Builder() {
        }

        public final Builder from(SearchGlobal instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SearchGlobal instance;
            long bits = 0L;
            if (object instanceof SearchGlobal) {
                instance = (SearchGlobal)object;
                this.filter(instance.filter());
                this.offsetRate(instance.offsetRate());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
                this.minDate(instance.minDate());
                this.offsetPeer(instance.offsetPeer());
                this.flags(instance.flags());
                this.limit(instance.limit());
                this.maxDate(instance.maxDate());
                Integer folderIdValue = instance.folderId();
                if (folderIdValue != null) {
                    this.folderId(folderIdValue);
                }
                this.offsetId(instance.offsetId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(MessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder minDate(int minDate) {
            this.minDate = minDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder maxDate(int maxDate) {
            this.maxDate = maxDate;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder offsetRate(int offsetRate) {
            this.offsetRate = offsetRate;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder offsetPeer(InputPeer offsetPeer) {
            this.offsetPeer = Objects.requireNonNull(offsetPeer, "offsetPeer");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableSearchGlobal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchGlobal(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("q");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("minDate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("maxDate");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("offsetRate");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("offsetPeer");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build SearchGlobal, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSearchGlobal.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSearchGlobal.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build SearchGlobal, attribute initializers form cycle " + attributes;
        }
    }
}

