/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SearchSentMedia;

public final class ImmutableSearchSentMedia
implements SearchSentMedia {
    private final int identifier;
    private final String q;
    private final MessagesFilter filter;
    private final int limit;

    private ImmutableSearchSentMedia(String q, MessagesFilter filter, int limit) {
        this.q = Objects.requireNonNull(q, "q");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.limit = limit;
        this.identifier = SearchSentMedia.super.identifier();
    }

    private ImmutableSearchSentMedia(Builder builder) {
        this.q = builder.q;
        this.filter = builder.filter;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SearchSentMedia.super.identifier();
    }

    private ImmutableSearchSentMedia(int identifier, String q, MessagesFilter filter, int limit) {
        this.identifier = identifier;
        this.q = q;
        this.filter = filter;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    public MessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableSearchSentMedia withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchSentMedia(value, this.q, this.filter, this.limit);
    }

    public final ImmutableSearchSentMedia withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableSearchSentMedia(this.identifier, newValue, this.filter, this.limit);
    }

    public final ImmutableSearchSentMedia withFilter(MessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        MessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableSearchSentMedia(this.identifier, this.q, newValue, this.limit);
    }

    public final ImmutableSearchSentMedia withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableSearchSentMedia(this.identifier, this.q, this.filter, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchSentMedia && this.equalTo(0, (ImmutableSearchSentMedia)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchSentMedia another) {
        return this.identifier == another.identifier && this.q.equals(another.q) && this.filter.equals(another.filter) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.q.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "SearchSentMedia{identifier=" + this.identifier + ", q=" + this.q + ", filter=" + this.filter + ", limit=" + this.limit + "}";
    }

    public static ImmutableSearchSentMedia of(String q, MessagesFilter filter, int limit) {
        return new ImmutableSearchSentMedia(q, filter, limit);
    }

    public static ImmutableSearchSentMedia copyOf(SearchSentMedia instance) {
        if (instance instanceof ImmutableSearchSentMedia) {
            return (ImmutableSearchSentMedia)instance;
        }
        return ImmutableSearchSentMedia.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_Q = 1L;
        private static final long INIT_BIT_FILTER = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String q;
        private MessagesFilter filter;
        private int limit;

        private Builder() {
        }

        public final Builder from(SearchSentMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SearchSentMedia instance;
            long bits = 0L;
            if (object instanceof SearchSentMedia) {
                instance = (SearchSentMedia)object;
                this.filter(instance.filter());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(MessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSearchSentMedia build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchSentMedia(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("q");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build SearchSentMedia, some of required attributes are not set " + attributes;
        }
    }
}

