/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SearchStickerSets;

public final class ImmutableSearchStickerSets
implements SearchStickerSets {
    private final int identifier;
    private final int flags;
    private final boolean excludeFeatured;
    private final String q;
    private final long hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSearchStickerSets(String q, long hash) {
        this.q = Objects.requireNonNull(q, "q");
        this.hash = hash;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.excludeFeatured = this.initShim.excludeFeatured();
        this.initShim = null;
    }

    private ImmutableSearchStickerSets(Builder builder) {
        this.q = builder.q;
        this.hash = builder.hash;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.excludeFeaturedIsSet()) {
            this.initShim.excludeFeatured(builder.excludeFeatured);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.excludeFeatured = this.initShim.excludeFeatured();
        this.initShim = null;
    }

    private ImmutableSearchStickerSets(int identifier, int flags, boolean excludeFeatured, String q, long hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.excludeFeatured = excludeFeatured;
        this.q = q;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SearchStickerSets.super.identifier();
    }

    private int flagsInitialize() {
        return SearchStickerSets.super.flags();
    }

    private boolean excludeFeaturedInitialize() {
        return SearchStickerSets.super.excludeFeatured();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean excludeFeatured() {
        InitShim shim = this.initShim;
        return shim != null ? shim.excludeFeatured() : this.excludeFeatured;
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableSearchStickerSets withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchStickerSets(value, this.flags, this.excludeFeatured, this.q, this.hash);
    }

    public final ImmutableSearchStickerSets withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSearchStickerSets(this.identifier, value, this.excludeFeatured, this.q, this.hash);
    }

    public final ImmutableSearchStickerSets withExcludeFeatured(boolean value) {
        if (this.excludeFeatured == value) {
            return this;
        }
        return new ImmutableSearchStickerSets(this.identifier, this.flags, value, this.q, this.hash);
    }

    public final ImmutableSearchStickerSets withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableSearchStickerSets(this.identifier, this.flags, this.excludeFeatured, newValue, this.hash);
    }

    public final ImmutableSearchStickerSets withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableSearchStickerSets(this.identifier, this.flags, this.excludeFeatured, this.q, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchStickerSets && this.equalTo(0, (ImmutableSearchStickerSets)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchStickerSets another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.excludeFeatured == another.excludeFeatured && this.q.equals(another.q) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.excludeFeatured);
        h += (h << 5) + this.q.hashCode();
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "SearchStickerSets{identifier=" + this.identifier + ", flags=" + this.flags + ", excludeFeatured=" + this.excludeFeatured + ", q=" + this.q + ", hash=" + this.hash + "}";
    }

    public static ImmutableSearchStickerSets of(String q, long hash) {
        return new ImmutableSearchStickerSets(q, hash);
    }

    public static ImmutableSearchStickerSets copyOf(SearchStickerSets instance) {
        if (instance instanceof ImmutableSearchStickerSets) {
            return (ImmutableSearchStickerSets)instance;
        }
        return ImmutableSearchStickerSets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_Q = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_EXCLUDE_FEATURED = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean excludeFeatured;
        private String q;
        private long hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SearchStickerSets instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SearchStickerSets) {
                instance = (SearchStickerSets)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
                this.excludeFeatured(instance.excludeFeatured());
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder excludeFeatured(boolean excludeFeatured) {
            this.excludeFeatured = excludeFeatured;
            this.optBits |= 4L;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSearchStickerSets build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchStickerSets(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean excludeFeaturedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("q");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build SearchStickerSets, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte excludeFeaturedBuildStage = 0;
        private boolean excludeFeatured;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSearchStickerSets.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSearchStickerSets.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean excludeFeatured() {
            if (this.excludeFeaturedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.excludeFeaturedBuildStage == 0) {
                this.excludeFeaturedBuildStage = (byte)-1;
                this.excludeFeatured = ImmutableSearchStickerSets.this.excludeFeaturedInitialize();
                this.excludeFeaturedBuildStage = 1;
            }
            return this.excludeFeatured;
        }

        void excludeFeatured(boolean excludeFeatured) {
            this.excludeFeatured = excludeFeatured;
            this.excludeFeaturedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.excludeFeaturedBuildStage == -1) {
                attributes.add("excludeFeatured");
            }
            return "Cannot build SearchStickerSets, attribute initializers form cycle " + attributes;
        }
    }
}

