/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.InputEncryptedFile;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendEncryptedFile;

public final class ImmutableSendEncryptedFile
implements SendEncryptedFile {
    private final int identifier;
    private final int flags;
    private final boolean silent;
    private final InputEncryptedChat peer;
    private final long randomId;
    private final ByteBuf data;
    private final InputEncryptedFile file;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendEncryptedFile(InputEncryptedChat peer, long randomId, InputEncryptedFile file) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.randomId = randomId;
        this.file = Objects.requireNonNull(file, "file");
        this.data = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableSendEncryptedFile(Builder builder) {
        this.peer = builder.peer;
        this.randomId = builder.randomId;
        this.data = builder.data_build();
        this.file = builder.file;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableSendEncryptedFile(int identifier, int flags, boolean silent, InputEncryptedChat peer, long randomId, ByteBuf data, InputEncryptedFile file) {
        this.identifier = identifier;
        this.flags = flags;
        this.silent = silent;
        this.peer = peer;
        this.randomId = randomId;
        this.data = data;
        this.file = file;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendEncryptedFile.super.identifier();
    }

    private int flagsInitialize() {
        return SendEncryptedFile.super.flags();
    }

    private boolean silentInitialize() {
        return SendEncryptedFile.super.silent();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public ByteBuf data() {
        return this.data.duplicate();
    }

    @Override
    public InputEncryptedFile file() {
        return this.file;
    }

    public final ImmutableSendEncryptedFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendEncryptedFile(value, this.flags, this.silent, this.peer, this.randomId, this.data, this.file);
    }

    public final ImmutableSendEncryptedFile withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSendEncryptedFile(this.identifier, value, this.silent, this.peer, this.randomId, this.data, this.file);
    }

    public final ImmutableSendEncryptedFile withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableSendEncryptedFile(this.identifier, this.flags, value, this.peer, this.randomId, this.data, this.file);
    }

    public final ImmutableSendEncryptedFile withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendEncryptedFile(this.identifier, this.flags, this.silent, newValue, this.randomId, this.data, this.file);
    }

    public final ImmutableSendEncryptedFile withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableSendEncryptedFile(this.identifier, this.flags, this.silent, this.peer, value, this.data, this.file);
    }

    public ImmutableSendEncryptedFile withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableSendEncryptedFile(this.identifier, this.flags, this.silent, this.peer, this.randomId, newValue, this.file);
    }

    public final ImmutableSendEncryptedFile withFile(InputEncryptedFile value) {
        if (this.file == value) {
            return this;
        }
        InputEncryptedFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableSendEncryptedFile(this.identifier, this.flags, this.silent, this.peer, this.randomId, this.data, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendEncryptedFile && this.equalTo(0, (ImmutableSendEncryptedFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendEncryptedFile another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.silent == another.silent && this.peer.equals(another.peer) && this.randomId == another.randomId && this.data().equals((Object)another.data()) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + this.data().hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "SendEncryptedFile{identifier=" + this.identifier + ", flags=" + this.flags + ", silent=" + this.silent + ", peer=" + this.peer + ", randomId=" + this.randomId + ", data=" + ByteBufUtil.hexDump((ByteBuf)this.data) + ", file=" + this.file + "}";
    }

    public static ImmutableSendEncryptedFile of(InputEncryptedChat peer, long randomId, InputEncryptedFile file) {
        return new ImmutableSendEncryptedFile(peer, randomId, file);
    }

    public static ImmutableSendEncryptedFile copyOf(SendEncryptedFile instance) {
        if (instance instanceof ImmutableSendEncryptedFile) {
            return (ImmutableSendEncryptedFile)instance;
        }
        return ImmutableSendEncryptedFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long INIT_BIT_FILE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SILENT = 4L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private int flags;
        private boolean silent;
        private InputEncryptedChat peer;
        private long randomId;
        private InputEncryptedFile file;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendEncryptedFile) {
                instance = (SendEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                this.randomId(instance.randomId());
                this.file(instance.file());
                this.data(instance.data());
                this.peer(instance.peer());
                this.flags(instance.flags());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder data(ByteBuf value) {
            this.data_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder file(InputEncryptedFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSendEncryptedFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendEncryptedFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build SendEncryptedFile, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return Objects.requireNonNull(this.data_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte silentBuildStage = 0;
        private boolean silent;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendEncryptedFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSendEncryptedFile.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableSendEncryptedFile.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            return "Cannot build SendEncryptedFile, attribute initializers form cycle " + attributes;
        }
    }
}

