/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendEncryptedService;

public final class ImmutableSendEncryptedService
implements SendEncryptedService {
    private final int identifier;
    private final InputEncryptedChat peer;
    private final long randomId;
    private final ByteBuf data;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendEncryptedService(InputEncryptedChat peer, long randomId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.randomId = randomId;
        this.data = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSendEncryptedService(Builder builder) {
        this.peer = builder.peer;
        this.randomId = builder.randomId;
        this.data = builder.data_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSendEncryptedService(int identifier, InputEncryptedChat peer, long randomId, ByteBuf data) {
        this.identifier = identifier;
        this.peer = peer;
        this.randomId = randomId;
        this.data = data;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendEncryptedService.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public ByteBuf data() {
        return this.data.duplicate();
    }

    public final ImmutableSendEncryptedService withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendEncryptedService(value, this.peer, this.randomId, this.data);
    }

    public final ImmutableSendEncryptedService withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendEncryptedService(this.identifier, newValue, this.randomId, this.data);
    }

    public final ImmutableSendEncryptedService withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableSendEncryptedService(this.identifier, this.peer, value, this.data);
    }

    public ImmutableSendEncryptedService withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableSendEncryptedService(this.identifier, this.peer, this.randomId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendEncryptedService && this.equalTo(0, (ImmutableSendEncryptedService)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendEncryptedService another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.randomId == another.randomId && this.data().equals((Object)another.data());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + this.data().hashCode();
        return h;
    }

    public String toString() {
        return "SendEncryptedService{identifier=" + this.identifier + ", peer=" + this.peer + ", randomId=" + this.randomId + ", data=" + ByteBufUtil.hexDump((ByteBuf)this.data) + "}";
    }

    public static ImmutableSendEncryptedService of(InputEncryptedChat peer, long randomId) {
        return new ImmutableSendEncryptedService(peer, randomId);
    }

    public static ImmutableSendEncryptedService copyOf(SendEncryptedService instance) {
        if (instance instanceof ImmutableSendEncryptedService) {
            return (ImmutableSendEncryptedService)instance;
        }
        return ImmutableSendEncryptedService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private InputEncryptedChat peer;
        private long randomId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendEncryptedService instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendEncryptedService) {
                instance = (SendEncryptedService)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.data(instance.data());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder data(ByteBuf value) {
            this.data_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSendEncryptedService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendEncryptedService(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            return "Cannot build SendEncryptedService, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return Objects.requireNonNull(this.data_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendEncryptedService.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SendEncryptedService, attribute initializers form cycle " + attributes;
        }
    }
}

