/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendInlineBotResult;

public final class ImmutableSendInlineBotResult
implements SendInlineBotResult {
    private final int identifier;
    private final int flags;
    private final boolean silent;
    private final boolean background;
    private final boolean clearDraft;
    private final boolean hideVia;
    private final InputPeer peer;
    @Nullable
    private final Integer replyToMsgId;
    private final long randomId;
    private final long queryId;
    private final String id;
    @Nullable
    private final Integer scheduleDate;
    @Nullable
    private final InputPeer sendAs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendInlineBotResult(InputPeer peer, long randomId, long queryId, String id) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.randomId = randomId;
        this.queryId = queryId;
        this.id = Objects.requireNonNull(id, "id");
        this.replyToMsgId = null;
        this.scheduleDate = null;
        this.sendAs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.clearDraft = this.initShim.clearDraft();
        this.hideVia = this.initShim.hideVia();
        this.initShim = null;
    }

    private ImmutableSendInlineBotResult(Builder builder) {
        this.peer = builder.peer;
        this.replyToMsgId = builder.replyToMsgId;
        this.randomId = builder.randomId;
        this.queryId = builder.queryId;
        this.id = builder.id;
        this.scheduleDate = builder.scheduleDate;
        this.sendAs = builder.sendAs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.backgroundIsSet()) {
            this.initShim.background(builder.background);
        }
        if (builder.clearDraftIsSet()) {
            this.initShim.clearDraft(builder.clearDraft);
        }
        if (builder.hideViaIsSet()) {
            this.initShim.hideVia(builder.hideVia);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.clearDraft = this.initShim.clearDraft();
        this.hideVia = this.initShim.hideVia();
        this.initShim = null;
    }

    private ImmutableSendInlineBotResult(int identifier, int flags, boolean silent, boolean background, boolean clearDraft, boolean hideVia, InputPeer peer, @Nullable Integer replyToMsgId, long randomId, long queryId, String id, @Nullable Integer scheduleDate, @Nullable InputPeer sendAs) {
        this.identifier = identifier;
        this.flags = flags;
        this.silent = silent;
        this.background = background;
        this.clearDraft = clearDraft;
        this.hideVia = hideVia;
        this.peer = peer;
        this.replyToMsgId = replyToMsgId;
        this.randomId = randomId;
        this.queryId = queryId;
        this.id = id;
        this.scheduleDate = scheduleDate;
        this.sendAs = sendAs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendInlineBotResult.super.identifier();
    }

    private int flagsInitialize() {
        return SendInlineBotResult.super.flags();
    }

    private boolean silentInitialize() {
        return SendInlineBotResult.super.silent();
    }

    private boolean backgroundInitialize() {
        return SendInlineBotResult.super.background();
    }

    private boolean clearDraftInitialize() {
        return SendInlineBotResult.super.clearDraft();
    }

    private boolean hideViaInitialize() {
        return SendInlineBotResult.super.hideVia();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean background() {
        InitShim shim = this.initShim;
        return shim != null ? shim.background() : this.background;
    }

    @Override
    public boolean clearDraft() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clearDraft() : this.clearDraft;
    }

    @Override
    public boolean hideVia() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hideVia() : this.hideVia;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    @Override
    @Nullable
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableSendInlineBotResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(value, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, value, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, value, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withBackground(boolean value) {
        if (this.background == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, value, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withClearDraft(boolean value) {
        if (this.clearDraft == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, value, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withHideVia(boolean value) {
        if (this.hideVia == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, value, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, newValue, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withReplyToMsgId(@Nullable Integer value) {
        if (Objects.equals(this.replyToMsgId, value)) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, value, this.randomId, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, value, this.queryId, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, value, this.id, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, newValue, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, value, this.sendAs);
    }

    public final ImmutableSendInlineBotResult withSendAs(@Nullable InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        return new ImmutableSendInlineBotResult(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.hideVia, this.peer, this.replyToMsgId, this.randomId, this.queryId, this.id, this.scheduleDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendInlineBotResult && this.equalTo(0, (ImmutableSendInlineBotResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendInlineBotResult another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.silent == another.silent && this.background == another.background && this.clearDraft == another.clearDraft && this.hideVia == another.hideVia && this.peer.equals(another.peer) && Objects.equals(this.replyToMsgId, another.replyToMsgId) && this.randomId == another.randomId && this.queryId == another.queryId && this.id.equals(another.id) && Objects.equals(this.scheduleDate, another.scheduleDate) && Objects.equals(this.sendAs, another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.background);
        h += (h << 5) + Boolean.hashCode(this.clearDraft);
        h += (h << 5) + Boolean.hashCode(this.hideVia);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.replyToMsgId);
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        h += (h << 5) + Objects.hashCode(this.sendAs);
        return h;
    }

    public String toString() {
        return "SendInlineBotResult{identifier=" + this.identifier + ", flags=" + this.flags + ", silent=" + this.silent + ", background=" + this.background + ", clearDraft=" + this.clearDraft + ", hideVia=" + this.hideVia + ", peer=" + this.peer + ", replyToMsgId=" + this.replyToMsgId + ", randomId=" + this.randomId + ", queryId=" + this.queryId + ", id=" + this.id + ", scheduleDate=" + this.scheduleDate + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableSendInlineBotResult of(InputPeer peer, long randomId, long queryId, String id) {
        return new ImmutableSendInlineBotResult(peer, randomId, queryId, id);
    }

    public static ImmutableSendInlineBotResult copyOf(SendInlineBotResult instance) {
        if (instance instanceof ImmutableSendInlineBotResult) {
            return (ImmutableSendInlineBotResult)instance;
        }
        return ImmutableSendInlineBotResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long INIT_BIT_QUERY_ID = 4L;
        private static final long INIT_BIT_ID = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SILENT = 4L;
        private static final long OPT_BIT_BACKGROUND = 8L;
        private static final long OPT_BIT_CLEAR_DRAFT = 16L;
        private static final long OPT_BIT_HIDE_VIA = 32L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean silent;
        private boolean background;
        private boolean clearDraft;
        private boolean hideVia;
        private InputPeer peer;
        private Integer replyToMsgId;
        private long randomId;
        private long queryId;
        private String id;
        private Integer scheduleDate;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendInlineBotResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendInlineBotResult) {
                Integer replyToMsgIdValue;
                InputPeer sendAsValue;
                instance = (SendInlineBotResult)object;
                this.clearDraft(instance.clearDraft());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                this.flags(instance.flags());
                this.hideVia(instance.hideVia());
                this.queryId(instance.queryId());
                this.randomId(instance.randomId());
                this.background(instance.background());
                this.peer(instance.peer());
                Integer scheduleDateValue = instance.scheduleDate();
                if (scheduleDateValue != null) {
                    this.scheduleDate(scheduleDateValue);
                }
                if ((sendAsValue = instance.sendAs()) != null) {
                    this.sendAs(sendAsValue);
                }
                if ((replyToMsgIdValue = instance.replyToMsgId()) != null) {
                    this.replyToMsgId(replyToMsgIdValue);
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder background(boolean background) {
            this.background = background;
            this.optBits |= 8L;
            return this;
        }

        public final Builder clearDraft(boolean clearDraft) {
            this.clearDraft = clearDraft;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder hideVia(boolean hideVia) {
            this.hideVia = hideVia;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder replyToMsgId(@Nullable Integer replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public final Builder sendAs(@Nullable InputPeer sendAs) {
            this.sendAs = sendAs;
            return this;
        }

        public ImmutableSendInlineBotResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendInlineBotResult(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean backgroundIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean clearDraftIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean hideViaIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build SendInlineBotResult, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte backgroundBuildStage = 0;
        private boolean background;
        private byte clearDraftBuildStage = 0;
        private boolean clearDraft;
        private byte hideViaBuildStage = 0;
        private boolean hideVia;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendInlineBotResult.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSendInlineBotResult.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableSendInlineBotResult.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean background() {
            if (this.backgroundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundBuildStage == 0) {
                this.backgroundBuildStage = (byte)-1;
                this.background = ImmutableSendInlineBotResult.this.backgroundInitialize();
                this.backgroundBuildStage = 1;
            }
            return this.background;
        }

        void background(boolean background) {
            this.background = background;
            this.backgroundBuildStage = 1;
        }

        boolean clearDraft() {
            if (this.clearDraftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clearDraftBuildStage == 0) {
                this.clearDraftBuildStage = (byte)-1;
                this.clearDraft = ImmutableSendInlineBotResult.this.clearDraftInitialize();
                this.clearDraftBuildStage = 1;
            }
            return this.clearDraft;
        }

        void clearDraft(boolean clearDraft) {
            this.clearDraft = clearDraft;
            this.clearDraftBuildStage = 1;
        }

        boolean hideVia() {
            if (this.hideViaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hideViaBuildStage == 0) {
                this.hideViaBuildStage = (byte)-1;
                this.hideVia = ImmutableSendInlineBotResult.this.hideViaInitialize();
                this.hideViaBuildStage = 1;
            }
            return this.hideVia;
        }

        void hideVia(boolean hideVia) {
            this.hideVia = hideVia;
            this.hideViaBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.backgroundBuildStage == -1) {
                attributes.add("background");
            }
            if (this.clearDraftBuildStage == -1) {
                attributes.add("clearDraft");
            }
            if (this.hideViaBuildStage == -1) {
                attributes.add("hideVia");
            }
            return "Cannot build SendInlineBotResult, attribute initializers form cycle " + attributes;
        }
    }
}

