/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.BaseSendMessageRequest;
import telegram4j.tl.request.messages.SendMessage;

public final class ImmutableSendMessage
implements SendMessage {
    private final int identifier;
    private final int flags;
    private final boolean noWebpage;
    private final boolean silent;
    private final boolean background;
    private final boolean clearDraft;
    private final boolean noforwards;
    private final InputPeer peer;
    @Nullable
    private final Integer replyToMsgId;
    private final String message;
    private final long randomId;
    @Nullable
    private final ReplyMarkup replyMarkup;
    @Nullable
    private final List<MessageEntity> entities;
    @Nullable
    private final Integer scheduleDate;
    @Nullable
    private final InputPeer sendAs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendMessage(InputPeer peer, String message, long randomId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.message = Objects.requireNonNull(message, "message");
        this.randomId = randomId;
        this.replyToMsgId = null;
        this.replyMarkup = null;
        this.entities = null;
        this.scheduleDate = null;
        this.sendAs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.clearDraft = this.initShim.clearDraft();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableSendMessage(Builder builder) {
        this.peer = builder.peer;
        this.replyToMsgId = builder.replyToMsgId;
        this.message = builder.message;
        this.randomId = builder.randomId;
        this.replyMarkup = builder.replyMarkup;
        this.entities = builder.entities == null ? null : ImmutableSendMessage.createUnmodifiableList(true, builder.entities);
        this.scheduleDate = builder.scheduleDate;
        this.sendAs = builder.sendAs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.noWebpageIsSet()) {
            this.initShim.noWebpage(builder.noWebpage);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.backgroundIsSet()) {
            this.initShim.background(builder.background);
        }
        if (builder.clearDraftIsSet()) {
            this.initShim.clearDraft(builder.clearDraft);
        }
        if (builder.noforwardsIsSet()) {
            this.initShim.noforwards(builder.noforwards);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.clearDraft = this.initShim.clearDraft();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableSendMessage(int identifier, int flags, boolean noWebpage, boolean silent, boolean background, boolean clearDraft, boolean noforwards, InputPeer peer, @Nullable Integer replyToMsgId, String message, long randomId, @Nullable ReplyMarkup replyMarkup, @Nullable List<MessageEntity> entities, @Nullable Integer scheduleDate, @Nullable InputPeer sendAs) {
        this.identifier = identifier;
        this.flags = flags;
        this.noWebpage = noWebpage;
        this.silent = silent;
        this.background = background;
        this.clearDraft = clearDraft;
        this.noforwards = noforwards;
        this.peer = peer;
        this.replyToMsgId = replyToMsgId;
        this.message = message;
        this.randomId = randomId;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
        this.scheduleDate = scheduleDate;
        this.sendAs = sendAs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendMessage.super.identifier();
    }

    private int flagsInitialize() {
        return SendMessage.super.flags();
    }

    private boolean noWebpageInitialize() {
        return SendMessage.super.noWebpage();
    }

    private boolean silentInitialize() {
        return SendMessage.super.silent();
    }

    private boolean backgroundInitialize() {
        return SendMessage.super.background();
    }

    private boolean clearDraftInitialize() {
        return SendMessage.super.clearDraft();
    }

    private boolean noforwardsInitialize() {
        return SendMessage.super.noforwards();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean noWebpage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noWebpage() : this.noWebpage;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean background() {
        InitShim shim = this.initShim;
        return shim != null ? shim.background() : this.background;
    }

    @Override
    public boolean clearDraft() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clearDraft() : this.clearDraft;
    }

    @Override
    public boolean noforwards() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noforwards() : this.noforwards;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    @Override
    @Nullable
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableSendMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendMessage(value, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, value, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withNoWebpage(boolean value) {
        if (this.noWebpage == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, value, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, value, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withBackground(boolean value) {
        if (this.background == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, value, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withClearDraft(boolean value) {
        if (this.clearDraft == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, value, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withNoforwards(boolean value) {
        if (this.noforwards == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, value, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, newValue, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withReplyToMsgId(@Nullable Integer value) {
        if (Objects.equals(this.replyToMsgId, value)) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, value, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, newValue, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, value, this.replyMarkup, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, value, this.entities, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, null, this.scheduleDate, this.sendAs);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableSendMessage.createUnmodifiableList(false, ImmutableSendMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, newValue, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableSendMessage.createUnmodifiableList(false, ImmutableSendMessage.createSafeList(elements, true, false));
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, newValue, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMessage withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, value, this.sendAs);
    }

    public final ImmutableSendMessage withSendAs(@Nullable InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        return new ImmutableSendMessage(this.identifier, this.flags, this.noWebpage, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.message, this.randomId, this.replyMarkup, this.entities, this.scheduleDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessage && this.equalTo(0, (ImmutableSendMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.noWebpage == another.noWebpage && this.silent == another.silent && this.background == another.background && this.clearDraft == another.clearDraft && this.noforwards == another.noforwards && this.peer.equals(another.peer) && Objects.equals(this.replyToMsgId, another.replyToMsgId) && this.message.equals(another.message) && this.randomId == another.randomId && Objects.equals(this.replyMarkup, another.replyMarkup) && Objects.equals(this.entities, another.entities) && Objects.equals(this.scheduleDate, another.scheduleDate) && Objects.equals(this.sendAs, another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.noWebpage);
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.background);
        h += (h << 5) + Boolean.hashCode(this.clearDraft);
        h += (h << 5) + Boolean.hashCode(this.noforwards);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.replyToMsgId);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        h += (h << 5) + Objects.hashCode(this.sendAs);
        return h;
    }

    public String toString() {
        return "SendMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", noWebpage=" + this.noWebpage + ", silent=" + this.silent + ", background=" + this.background + ", clearDraft=" + this.clearDraft + ", noforwards=" + this.noforwards + ", peer=" + this.peer + ", replyToMsgId=" + this.replyToMsgId + ", message=" + this.message + ", randomId=" + this.randomId + ", replyMarkup=" + this.replyMarkup + ", entities=" + this.entities + ", scheduleDate=" + this.scheduleDate + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableSendMessage of(InputPeer peer, String message, long randomId) {
        return new ImmutableSendMessage(peer, message, randomId);
    }

    public static ImmutableSendMessage copyOf(SendMessage instance) {
        if (instance instanceof ImmutableSendMessage) {
            return (ImmutableSendMessage)instance;
        }
        return ImmutableSendMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private static final long INIT_BIT_RANDOM_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NO_WEBPAGE = 4L;
        private static final long OPT_BIT_SILENT = 8L;
        private static final long OPT_BIT_BACKGROUND = 16L;
        private static final long OPT_BIT_CLEAR_DRAFT = 32L;
        private static final long OPT_BIT_NOFORWARDS = 64L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean noWebpage;
        private boolean silent;
        private boolean background;
        private boolean clearDraft;
        private boolean noforwards;
        private InputPeer peer;
        private Integer replyToMsgId;
        private String message;
        private long randomId;
        private ReplyMarkup replyMarkup;
        private List<MessageEntity> entities = null;
        private Integer scheduleDate;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseSendMessageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer replyToMsgIdValue;
            InputPeer sendAsValue;
            Integer scheduleDateValue;
            ReplyMarkup replyMarkupValue;
            List<MessageEntity> entitiesValue;
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof SendMessage) {
                instance = (SendMessage)object;
                if ((bits & 1L) == 0L) {
                    this.clearDraft(instance.clearDraft());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.silent(instance.silent());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.noforwards(instance.noforwards());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.message(instance.message());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.randomId(instance.randomId());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    entitiesValue = instance.entities();
                    if (entitiesValue != null) {
                        this.addAllEntities(entitiesValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.background(instance.background());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.peer(instance.peer());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    scheduleDateValue = instance.scheduleDate();
                    if (scheduleDateValue != null) {
                        this.scheduleDate(scheduleDateValue);
                    }
                    bits |= 0x800L;
                }
                this.noWebpage(instance.noWebpage());
                if ((bits & 0x1000L) == 0L) {
                    sendAsValue = instance.sendAs();
                    if (sendAsValue != null) {
                        this.sendAs(sendAsValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    replyToMsgIdValue = instance.replyToMsgId();
                    if (replyToMsgIdValue != null) {
                        this.replyToMsgId(replyToMsgIdValue);
                    }
                    bits |= 0x2000L;
                }
            }
            if (object instanceof BaseSendMessageRequest) {
                instance = (BaseSendMessageRequest)object;
                if ((bits & 1L) == 0L) {
                    this.clearDraft(instance.clearDraft());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.silent(instance.silent());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.noforwards(instance.noforwards());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.message(instance.message());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.randomId(instance.randomId());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    entitiesValue = instance.entities();
                    if (entitiesValue != null) {
                        this.addAllEntities(entitiesValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.background(instance.background());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.peer(instance.peer());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    scheduleDateValue = instance.scheduleDate();
                    if (scheduleDateValue != null) {
                        this.scheduleDate(scheduleDateValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    sendAsValue = instance.sendAs();
                    if (sendAsValue != null) {
                        this.sendAs(sendAsValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    replyToMsgIdValue = instance.replyToMsgId();
                    if (replyToMsgIdValue != null) {
                        this.replyToMsgId(replyToMsgIdValue);
                    }
                    bits |= 0x2000L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 8L;
            return this;
        }

        public final Builder background(boolean background) {
            this.background = background;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder clearDraft(boolean clearDraft) {
            this.clearDraft = clearDraft;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder replyToMsgId(@Nullable Integer replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public final Builder sendAs(@Nullable InputPeer sendAs) {
            this.sendAs = sendAs;
            return this;
        }

        public ImmutableSendMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noWebpageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean backgroundIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean clearDraftIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean noforwardsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("randomId");
            }
            return "Cannot build SendMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte noWebpageBuildStage = 0;
        private boolean noWebpage;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte backgroundBuildStage = 0;
        private boolean background;
        private byte clearDraftBuildStage = 0;
        private boolean clearDraft;
        private byte noforwardsBuildStage = 0;
        private boolean noforwards;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSendMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean noWebpage() {
            if (this.noWebpageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noWebpageBuildStage == 0) {
                this.noWebpageBuildStage = (byte)-1;
                this.noWebpage = ImmutableSendMessage.this.noWebpageInitialize();
                this.noWebpageBuildStage = 1;
            }
            return this.noWebpage;
        }

        void noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.noWebpageBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableSendMessage.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean background() {
            if (this.backgroundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundBuildStage == 0) {
                this.backgroundBuildStage = (byte)-1;
                this.background = ImmutableSendMessage.this.backgroundInitialize();
                this.backgroundBuildStage = 1;
            }
            return this.background;
        }

        void background(boolean background) {
            this.background = background;
            this.backgroundBuildStage = 1;
        }

        boolean clearDraft() {
            if (this.clearDraftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clearDraftBuildStage == 0) {
                this.clearDraftBuildStage = (byte)-1;
                this.clearDraft = ImmutableSendMessage.this.clearDraftInitialize();
                this.clearDraftBuildStage = 1;
            }
            return this.clearDraft;
        }

        void clearDraft(boolean clearDraft) {
            this.clearDraft = clearDraft;
            this.clearDraftBuildStage = 1;
        }

        boolean noforwards() {
            if (this.noforwardsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noforwardsBuildStage == 0) {
                this.noforwardsBuildStage = (byte)-1;
                this.noforwards = ImmutableSendMessage.this.noforwardsInitialize();
                this.noforwardsBuildStage = 1;
            }
            return this.noforwards;
        }

        void noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.noforwardsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.noWebpageBuildStage == -1) {
                attributes.add("noWebpage");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.backgroundBuildStage == -1) {
                attributes.add("background");
            }
            if (this.clearDraftBuildStage == -1) {
                attributes.add("clearDraft");
            }
            if (this.noforwardsBuildStage == -1) {
                attributes.add("noforwards");
            }
            return "Cannot build SendMessage, attribute initializers form cycle " + attributes;
        }
    }
}

