/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputSingleMedia;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendMultiMedia;

public final class ImmutableSendMultiMedia
implements SendMultiMedia {
    private final int identifier;
    private final int flags;
    private final boolean silent;
    private final boolean background;
    private final boolean clearDraft;
    private final boolean noforwards;
    private final InputPeer peer;
    @Nullable
    private final Integer replyToMsgId;
    private final List<InputSingleMedia> multiMedia;
    @Nullable
    private final Integer scheduleDate;
    @Nullable
    private final InputPeer sendAs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendMultiMedia(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.replyToMsgId = null;
        this.multiMedia = Collections.emptyList();
        this.scheduleDate = null;
        this.sendAs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.clearDraft = this.initShim.clearDraft();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableSendMultiMedia(Builder builder) {
        this.peer = builder.peer;
        this.replyToMsgId = builder.replyToMsgId;
        this.multiMedia = ImmutableSendMultiMedia.createUnmodifiableList(true, builder.multiMedia);
        this.scheduleDate = builder.scheduleDate;
        this.sendAs = builder.sendAs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.backgroundIsSet()) {
            this.initShim.background(builder.background);
        }
        if (builder.clearDraftIsSet()) {
            this.initShim.clearDraft(builder.clearDraft);
        }
        if (builder.noforwardsIsSet()) {
            this.initShim.noforwards(builder.noforwards);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.clearDraft = this.initShim.clearDraft();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableSendMultiMedia(int identifier, int flags, boolean silent, boolean background, boolean clearDraft, boolean noforwards, InputPeer peer, @Nullable Integer replyToMsgId, List<InputSingleMedia> multiMedia, @Nullable Integer scheduleDate, @Nullable InputPeer sendAs) {
        this.identifier = identifier;
        this.flags = flags;
        this.silent = silent;
        this.background = background;
        this.clearDraft = clearDraft;
        this.noforwards = noforwards;
        this.peer = peer;
        this.replyToMsgId = replyToMsgId;
        this.multiMedia = multiMedia;
        this.scheduleDate = scheduleDate;
        this.sendAs = sendAs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendMultiMedia.super.identifier();
    }

    private int flagsInitialize() {
        return SendMultiMedia.super.flags();
    }

    private boolean silentInitialize() {
        return SendMultiMedia.super.silent();
    }

    private boolean backgroundInitialize() {
        return SendMultiMedia.super.background();
    }

    private boolean clearDraftInitialize() {
        return SendMultiMedia.super.clearDraft();
    }

    private boolean noforwardsInitialize() {
        return SendMultiMedia.super.noforwards();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean background() {
        InitShim shim = this.initShim;
        return shim != null ? shim.background() : this.background;
    }

    @Override
    public boolean clearDraft() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clearDraft() : this.clearDraft;
    }

    @Override
    public boolean noforwards() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noforwards() : this.noforwards;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    public List<InputSingleMedia> multiMedia() {
        return this.multiMedia;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    @Override
    @Nullable
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableSendMultiMedia withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(value, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, value, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, value, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withBackground(boolean value) {
        if (this.background == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, value, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withClearDraft(boolean value) {
        if (this.clearDraft == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, value, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withNoforwards(boolean value) {
        if (this.noforwards == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, value, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, newValue, this.replyToMsgId, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withReplyToMsgId(@Nullable Integer value) {
        if (Objects.equals(this.replyToMsgId, value)) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, value, this.multiMedia, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withMultiMedia(InputSingleMedia ... elements) {
        List<InputSingleMedia> newValue = ImmutableSendMultiMedia.createUnmodifiableList(false, ImmutableSendMultiMedia.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, newValue, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withMultiMedia(Iterable<? extends InputSingleMedia> elements) {
        if (this.multiMedia == elements) {
            return this;
        }
        List<InputSingleMedia> newValue = ImmutableSendMultiMedia.createUnmodifiableList(false, ImmutableSendMultiMedia.createSafeList(elements, true, false));
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, newValue, this.scheduleDate, this.sendAs);
    }

    public final ImmutableSendMultiMedia withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, value, this.sendAs);
    }

    public final ImmutableSendMultiMedia withSendAs(@Nullable InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        return new ImmutableSendMultiMedia(this.identifier, this.flags, this.silent, this.background, this.clearDraft, this.noforwards, this.peer, this.replyToMsgId, this.multiMedia, this.scheduleDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMultiMedia && this.equalTo(0, (ImmutableSendMultiMedia)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMultiMedia another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.silent == another.silent && this.background == another.background && this.clearDraft == another.clearDraft && this.noforwards == another.noforwards && this.peer.equals(another.peer) && Objects.equals(this.replyToMsgId, another.replyToMsgId) && this.multiMedia.equals(another.multiMedia) && Objects.equals(this.scheduleDate, another.scheduleDate) && Objects.equals(this.sendAs, another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.background);
        h += (h << 5) + Boolean.hashCode(this.clearDraft);
        h += (h << 5) + Boolean.hashCode(this.noforwards);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.replyToMsgId);
        h += (h << 5) + this.multiMedia.hashCode();
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        h += (h << 5) + Objects.hashCode(this.sendAs);
        return h;
    }

    public String toString() {
        return "SendMultiMedia{identifier=" + this.identifier + ", flags=" + this.flags + ", silent=" + this.silent + ", background=" + this.background + ", clearDraft=" + this.clearDraft + ", noforwards=" + this.noforwards + ", peer=" + this.peer + ", replyToMsgId=" + this.replyToMsgId + ", multiMedia=" + this.multiMedia + ", scheduleDate=" + this.scheduleDate + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableSendMultiMedia of(InputPeer peer) {
        return new ImmutableSendMultiMedia(peer);
    }

    public static ImmutableSendMultiMedia copyOf(SendMultiMedia instance) {
        if (instance instanceof ImmutableSendMultiMedia) {
            return (ImmutableSendMultiMedia)instance;
        }
        return ImmutableSendMultiMedia.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SILENT = 4L;
        private static final long OPT_BIT_BACKGROUND = 8L;
        private static final long OPT_BIT_CLEAR_DRAFT = 16L;
        private static final long OPT_BIT_NOFORWARDS = 32L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean silent;
        private boolean background;
        private boolean clearDraft;
        private boolean noforwards;
        private InputPeer peer;
        private Integer replyToMsgId;
        private List<InputSingleMedia> multiMedia = new ArrayList<InputSingleMedia>();
        private Integer scheduleDate;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(SendMultiMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMultiMedia instance;
            long bits = 0L;
            if (object instanceof SendMultiMedia) {
                Integer replyToMsgIdValue;
                InputPeer sendAsValue;
                instance = (SendMultiMedia)object;
                this.clearDraft(instance.clearDraft());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                this.background(instance.background());
                this.noforwards(instance.noforwards());
                this.peer(instance.peer());
                this.flags(instance.flags());
                Integer scheduleDateValue = instance.scheduleDate();
                if (scheduleDateValue != null) {
                    this.scheduleDate(scheduleDateValue);
                }
                if ((sendAsValue = instance.sendAs()) != null) {
                    this.sendAs(sendAsValue);
                }
                if ((replyToMsgIdValue = instance.replyToMsgId()) != null) {
                    this.replyToMsgId(replyToMsgIdValue);
                }
                this.addAllMultiMedia(instance.multiMedia());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder background(boolean background) {
            this.background = background;
            this.optBits |= 8L;
            return this;
        }

        public final Builder clearDraft(boolean clearDraft) {
            this.clearDraft = clearDraft;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder replyToMsgId(@Nullable Integer replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            return this;
        }

        public final Builder addMultiMedia(InputSingleMedia element) {
            this.multiMedia.add(Objects.requireNonNull(element, "multiMedia element"));
            return this;
        }

        public final Builder addMultiMedia(InputSingleMedia ... elements) {
            for (InputSingleMedia element : elements) {
                this.multiMedia.add(Objects.requireNonNull(element, "multiMedia element"));
            }
            return this;
        }

        public final Builder multiMedia(Iterable<? extends InputSingleMedia> elements) {
            this.multiMedia.clear();
            return this.addAllMultiMedia(elements);
        }

        public final Builder addAllMultiMedia(Iterable<? extends InputSingleMedia> elements) {
            for (InputSingleMedia inputSingleMedia : elements) {
                this.multiMedia.add(Objects.requireNonNull(inputSingleMedia, "multiMedia element"));
            }
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public final Builder sendAs(@Nullable InputPeer sendAs) {
            this.sendAs = sendAs;
            return this;
        }

        public ImmutableSendMultiMedia build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendMultiMedia(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean backgroundIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean clearDraftIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean noforwardsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build SendMultiMedia, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte backgroundBuildStage = 0;
        private boolean background;
        private byte clearDraftBuildStage = 0;
        private boolean clearDraft;
        private byte noforwardsBuildStage = 0;
        private boolean noforwards;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendMultiMedia.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSendMultiMedia.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableSendMultiMedia.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean background() {
            if (this.backgroundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundBuildStage == 0) {
                this.backgroundBuildStage = (byte)-1;
                this.background = ImmutableSendMultiMedia.this.backgroundInitialize();
                this.backgroundBuildStage = 1;
            }
            return this.background;
        }

        void background(boolean background) {
            this.background = background;
            this.backgroundBuildStage = 1;
        }

        boolean clearDraft() {
            if (this.clearDraftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clearDraftBuildStage == 0) {
                this.clearDraftBuildStage = (byte)-1;
                this.clearDraft = ImmutableSendMultiMedia.this.clearDraftInitialize();
                this.clearDraftBuildStage = 1;
            }
            return this.clearDraft;
        }

        void clearDraft(boolean clearDraft) {
            this.clearDraft = clearDraft;
            this.clearDraftBuildStage = 1;
        }

        boolean noforwards() {
            if (this.noforwardsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noforwardsBuildStage == 0) {
                this.noforwardsBuildStage = (byte)-1;
                this.noforwards = ImmutableSendMultiMedia.this.noforwardsInitialize();
                this.noforwardsBuildStage = 1;
            }
            return this.noforwards;
        }

        void noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.noforwardsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.backgroundBuildStage == -1) {
                attributes.add("background");
            }
            if (this.clearDraftBuildStage == -1) {
                attributes.add("clearDraft");
            }
            if (this.noforwardsBuildStage == -1) {
                attributes.add("noforwards");
            }
            return "Cannot build SendMultiMedia, attribute initializers form cycle " + attributes;
        }
    }
}

