/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendReaction;

public final class ImmutableSendReaction
implements SendReaction {
    private final int identifier;
    private final int flags;
    private final boolean big;
    private final InputPeer peer;
    private final int msgId;
    @Nullable
    private final String reaction;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendReaction(InputPeer peer, int msgId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.reaction = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.initShim = null;
    }

    private ImmutableSendReaction(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.reaction = builder.reaction;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.bigIsSet()) {
            this.initShim.big(builder.big);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.initShim = null;
    }

    private ImmutableSendReaction(int identifier, int flags, boolean big, InputPeer peer, int msgId, @Nullable String reaction) {
        this.identifier = identifier;
        this.flags = flags;
        this.big = big;
        this.peer = peer;
        this.msgId = msgId;
        this.reaction = reaction;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendReaction.super.identifier();
    }

    private int flagsInitialize() {
        return SendReaction.super.flags();
    }

    private boolean bigInitialize() {
        return SendReaction.super.big();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean big() {
        InitShim shim = this.initShim;
        return shim != null ? shim.big() : this.big;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    @Nullable
    public String reaction() {
        return this.reaction;
    }

    public final ImmutableSendReaction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendReaction(value, this.flags, this.big, this.peer, this.msgId, this.reaction);
    }

    public final ImmutableSendReaction withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSendReaction(this.identifier, value, this.big, this.peer, this.msgId, this.reaction);
    }

    public final ImmutableSendReaction withBig(boolean value) {
        if (this.big == value) {
            return this;
        }
        return new ImmutableSendReaction(this.identifier, this.flags, value, this.peer, this.msgId, this.reaction);
    }

    public final ImmutableSendReaction withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendReaction(this.identifier, this.flags, this.big, newValue, this.msgId, this.reaction);
    }

    public final ImmutableSendReaction withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableSendReaction(this.identifier, this.flags, this.big, this.peer, value, this.reaction);
    }

    public final ImmutableSendReaction withReaction(@Nullable String value) {
        if (Objects.equals(this.reaction, value)) {
            return this;
        }
        return new ImmutableSendReaction(this.identifier, this.flags, this.big, this.peer, this.msgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendReaction && this.equalTo(0, (ImmutableSendReaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendReaction another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.big == another.big && this.peer.equals(another.peer) && this.msgId == another.msgId && Objects.equals(this.reaction, another.reaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.big);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + Objects.hashCode(this.reaction);
        return h;
    }

    public String toString() {
        return "SendReaction{identifier=" + this.identifier + ", flags=" + this.flags + ", big=" + this.big + ", peer=" + this.peer + ", msgId=" + this.msgId + ", reaction=" + this.reaction + "}";
    }

    public static ImmutableSendReaction of(InputPeer peer, int msgId) {
        return new ImmutableSendReaction(peer, msgId);
    }

    public static ImmutableSendReaction copyOf(SendReaction instance) {
        if (instance instanceof ImmutableSendReaction) {
            return (ImmutableSendReaction)instance;
        }
        return ImmutableSendReaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BIG = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean big;
        private InputPeer peer;
        private int msgId;
        private String reaction;

        private Builder() {
        }

        public final Builder from(SendReaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendReaction instance;
            long bits = 0L;
            if (object instanceof SendReaction) {
                instance = (SendReaction)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.big(instance.big());
                this.msgId(instance.msgId());
                String reactionValue = instance.reaction();
                if (reactionValue != null) {
                    this.reaction(reactionValue);
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder big(boolean big) {
            this.big = big;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder reaction(@Nullable String reaction) {
            this.reaction = reaction;
            return this;
        }

        public ImmutableSendReaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendReaction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean bigIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build SendReaction, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte bigBuildStage = 0;
        private boolean big;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendReaction.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSendReaction.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean big() {
            if (this.bigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bigBuildStage == 0) {
                this.bigBuildStage = (byte)-1;
                this.big = ImmutableSendReaction.this.bigInitialize();
                this.bigBuildStage = 1;
            }
            return this.big;
        }

        void big(boolean big) {
            this.big = big;
            this.bigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.bigBuildStage == -1) {
                attributes.add("big");
            }
            return "Cannot build SendReaction, attribute initializers form cycle " + attributes;
        }
    }
}

