/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendScheduledMessages;

public final class ImmutableSendScheduledMessages
implements SendScheduledMessages {
    private final int identifier;
    private final InputPeer peer;
    private final List<Integer> id;

    private ImmutableSendScheduledMessages(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = Collections.emptyList();
        this.identifier = SendScheduledMessages.super.identifier();
    }

    private ImmutableSendScheduledMessages(Builder builder) {
        this.peer = builder.peer;
        this.id = ImmutableSendScheduledMessages.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendScheduledMessages.super.identifier();
    }

    private ImmutableSendScheduledMessages(int identifier, InputPeer peer, List<Integer> id) {
        this.identifier = identifier;
        this.peer = peer;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public List<Integer> id() {
        return this.id;
    }

    public final ImmutableSendScheduledMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendScheduledMessages(value, this.peer, this.id);
    }

    public final ImmutableSendScheduledMessages withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendScheduledMessages(this.identifier, newValue, this.id);
    }

    public final ImmutableSendScheduledMessages withId(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableSendScheduledMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableSendScheduledMessages(this.identifier, this.peer, newValue);
    }

    public final ImmutableSendScheduledMessages withId(Iterable<Integer> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableSendScheduledMessages.createUnmodifiableList(false, ImmutableSendScheduledMessages.createSafeList(elements, true, false));
        return new ImmutableSendScheduledMessages(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendScheduledMessages && this.equalTo(0, (ImmutableSendScheduledMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendScheduledMessages another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "SendScheduledMessages{identifier=" + this.identifier + ", peer=" + this.peer + ", id=" + this.id + "}";
    }

    public static ImmutableSendScheduledMessages of(InputPeer peer) {
        return new ImmutableSendScheduledMessages(peer);
    }

    public static ImmutableSendScheduledMessages copyOf(SendScheduledMessages instance) {
        if (instance instanceof ImmutableSendScheduledMessages) {
            return (ImmutableSendScheduledMessages)instance;
        }
        return ImmutableSendScheduledMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private List<Integer> id = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(SendScheduledMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendScheduledMessages instance;
            long bits = 0L;
            if (object instanceof SendScheduledMessages) {
                instance = (SendScheduledMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addId(int element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(int ... elements) {
            for (int element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Integer> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public ImmutableSendScheduledMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendScheduledMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build SendScheduledMessages, some of required attributes are not set " + attributes;
        }
    }
}

