/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendScreenshotNotification;

public final class ImmutableSendScreenshotNotification
implements SendScreenshotNotification {
    private final int identifier;
    private final InputPeer peer;
    private final int replyToMsgId;
    private final long randomId;

    private ImmutableSendScreenshotNotification(InputPeer peer, int replyToMsgId, long randomId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.replyToMsgId = replyToMsgId;
        this.randomId = randomId;
        this.identifier = SendScreenshotNotification.super.identifier();
    }

    private ImmutableSendScreenshotNotification(Builder builder) {
        this.peer = builder.peer;
        this.replyToMsgId = builder.replyToMsgId;
        this.randomId = builder.randomId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendScreenshotNotification.super.identifier();
    }

    private ImmutableSendScreenshotNotification(int identifier, InputPeer peer, int replyToMsgId, long randomId) {
        this.identifier = identifier;
        this.peer = peer;
        this.replyToMsgId = replyToMsgId;
        this.randomId = randomId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    public final ImmutableSendScreenshotNotification withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendScreenshotNotification(value, this.peer, this.replyToMsgId, this.randomId);
    }

    public final ImmutableSendScreenshotNotification withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendScreenshotNotification(this.identifier, newValue, this.replyToMsgId, this.randomId);
    }

    public final ImmutableSendScreenshotNotification withReplyToMsgId(int value) {
        if (this.replyToMsgId == value) {
            return this;
        }
        return new ImmutableSendScreenshotNotification(this.identifier, this.peer, value, this.randomId);
    }

    public final ImmutableSendScreenshotNotification withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableSendScreenshotNotification(this.identifier, this.peer, this.replyToMsgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendScreenshotNotification && this.equalTo(0, (ImmutableSendScreenshotNotification)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendScreenshotNotification another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.replyToMsgId == another.replyToMsgId && this.randomId == another.randomId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.replyToMsgId;
        h += (h << 5) + Long.hashCode(this.randomId);
        return h;
    }

    public String toString() {
        return "SendScreenshotNotification{identifier=" + this.identifier + ", peer=" + this.peer + ", replyToMsgId=" + this.replyToMsgId + ", randomId=" + this.randomId + "}";
    }

    public static ImmutableSendScreenshotNotification of(InputPeer peer, int replyToMsgId, long randomId) {
        return new ImmutableSendScreenshotNotification(peer, replyToMsgId, randomId);
    }

    public static ImmutableSendScreenshotNotification copyOf(SendScreenshotNotification instance) {
        if (instance instanceof ImmutableSendScreenshotNotification) {
            return (ImmutableSendScreenshotNotification)instance;
        }
        return ImmutableSendScreenshotNotification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_REPLY_TO_MSG_ID = 2L;
        private static final long INIT_BIT_RANDOM_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int replyToMsgId;
        private long randomId;

        private Builder() {
        }

        public final Builder from(SendScreenshotNotification instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendScreenshotNotification instance;
            long bits = 0L;
            if (object instanceof SendScreenshotNotification) {
                instance = (SendScreenshotNotification)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.replyToMsgId(instance.replyToMsgId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder replyToMsgId(int replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSendScreenshotNotification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendScreenshotNotification(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("replyToMsgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("randomId");
            }
            return "Cannot build SendScreenshotNotification, some of required attributes are not set " + attributes;
        }
    }
}

