/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendVote;

public final class ImmutableSendVote
implements SendVote {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;
    private final List<ByteBuf> options;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendVote(InputPeer peer, int msgId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.options = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSendVote(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.options = builder.options_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSendVote(int identifier, InputPeer peer, int msgId, List<ByteBuf> options) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
        this.options = options;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendVote.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public List<ByteBuf> options() {
        return this.options.stream().map(ByteBuf::duplicate).collect(Collectors.toList());
    }

    public final ImmutableSendVote withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendVote(value, this.peer, this.msgId, this.options);
    }

    public final ImmutableSendVote withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendVote(this.identifier, newValue, this.msgId, this.options);
    }

    public final ImmutableSendVote withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableSendVote(this.identifier, this.peer, value, this.options);
    }

    public ImmutableSendVote withOptions(Iterable<? extends ByteBuf> value) {
        List<ByteBuf> newValue = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
        if (this.options == newValue) {
            return this;
        }
        return new ImmutableSendVote(this.identifier, this.peer, this.msgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendVote && this.equalTo(0, (ImmutableSendVote)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendVote another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId && this.options().equals(another.options());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.options().hashCode();
        return h;
    }

    public String toString() {
        return "SendVote{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + ", options=" + this.options.stream().map(ByteBufUtil::hexDump).collect(Collectors.joining(", ", "[", "]")) + "}";
    }

    public static ImmutableSendVote of(InputPeer peer, int msgId) {
        return new ImmutableSendVote(peer, msgId);
    }

    public static ImmutableSendVote copyOf(SendVote instance) {
        if (instance instanceof ImmutableSendVote) {
            return (ImmutableSendVote)instance;
        }
        return ImmutableSendVote.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private List<ByteBuf> options_value = null;
        private int identifier;
        private InputPeer peer;
        private int msgId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendVote instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendVote) {
                instance = (SendVote)object;
                this.options(instance.options());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder addOption(ByteBuf value) {
            this.options_getOrCreate().add(TlEncodingUtil.copyAsUnpooled((ByteBuf)value));
            return this;
        }

        public Builder addAllOptions(Iterable<? extends ByteBuf> value) {
            this.options_getOrCreate().addAll(StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder addAllOptions(ByteBuf ... value) {
            this.options_getOrCreate().addAll(Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder options(Iterable<? extends ByteBuf> value) {
            this.options_value = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public Builder options(ByteBuf ... value) {
            this.options_value = Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public ImmutableSendVote build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendVote(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build SendVote, some of required attributes are not set " + attributes;
        }

        private List<ByteBuf> options_build() {
            return TlEncodingUtil.unmodifiableList(this.options_value);
        }

        private List<ByteBuf> options_getOrCreate() {
            if (this.options_value == null) {
                this.options_value = new ArrayList<ByteBuf>();
            }
            return this.options_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendVote.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SendVote, attribute initializers form cycle " + attributes;
        }
    }
}

