/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendWebViewData;

public final class ImmutableSendWebViewData
implements SendWebViewData {
    private final int identifier;
    private final InputUser bot;
    private final long randomId;
    private final String buttonText;
    private final String data;

    private ImmutableSendWebViewData(InputUser bot, long randomId, String buttonText, String data) {
        this.bot = Objects.requireNonNull(bot, "bot");
        this.randomId = randomId;
        this.buttonText = Objects.requireNonNull(buttonText, "buttonText");
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = SendWebViewData.super.identifier();
    }

    private ImmutableSendWebViewData(Builder builder) {
        this.bot = builder.bot;
        this.randomId = builder.randomId;
        this.buttonText = builder.buttonText;
        this.data = builder.data;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendWebViewData.super.identifier();
    }

    private ImmutableSendWebViewData(int identifier, InputUser bot, long randomId, String buttonText, String data) {
        this.identifier = identifier;
        this.bot = bot;
        this.randomId = randomId;
        this.buttonText = buttonText;
        this.data = data;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public String buttonText() {
        return this.buttonText;
    }

    @Override
    public String data() {
        return this.data;
    }

    public final ImmutableSendWebViewData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendWebViewData(value, this.bot, this.randomId, this.buttonText, this.data);
    }

    public final ImmutableSendWebViewData withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableSendWebViewData(this.identifier, newValue, this.randomId, this.buttonText, this.data);
    }

    public final ImmutableSendWebViewData withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableSendWebViewData(this.identifier, this.bot, value, this.buttonText, this.data);
    }

    public final ImmutableSendWebViewData withButtonText(String value) {
        String newValue = Objects.requireNonNull(value, "buttonText");
        if (this.buttonText.equals(newValue)) {
            return this;
        }
        return new ImmutableSendWebViewData(this.identifier, this.bot, this.randomId, newValue, this.data);
    }

    public final ImmutableSendWebViewData withData(String value) {
        String newValue = Objects.requireNonNull(value, "data");
        if (this.data.equals(newValue)) {
            return this;
        }
        return new ImmutableSendWebViewData(this.identifier, this.bot, this.randomId, this.buttonText, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendWebViewData && this.equalTo(0, (ImmutableSendWebViewData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendWebViewData another) {
        return this.identifier == another.identifier && this.bot.equals(another.bot) && this.randomId == another.randomId && this.buttonText.equals(another.buttonText) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + this.buttonText.hashCode();
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "SendWebViewData{identifier=" + this.identifier + ", bot=" + this.bot + ", randomId=" + this.randomId + ", buttonText=" + this.buttonText + ", data=" + this.data + "}";
    }

    public static ImmutableSendWebViewData of(InputUser bot, long randomId, String buttonText, String data) {
        return new ImmutableSendWebViewData(bot, randomId, buttonText, data);
    }

    public static ImmutableSendWebViewData copyOf(SendWebViewData instance) {
        if (instance instanceof ImmutableSendWebViewData) {
            return (ImmutableSendWebViewData)instance;
        }
        return ImmutableSendWebViewData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long INIT_BIT_BUTTON_TEXT = 4L;
        private static final long INIT_BIT_DATA = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputUser bot;
        private long randomId;
        private String buttonText;
        private String data;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendWebViewData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendWebViewData) {
                instance = (SendWebViewData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.buttonText(instance.buttonText());
                this.randomId(instance.randomId());
                this.data(instance.data());
                this.bot(instance.bot());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder buttonText(String buttonText) {
            this.buttonText = Objects.requireNonNull(buttonText, "buttonText");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder data(String data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSendWebViewData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendWebViewData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bot");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("buttonText");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build SendWebViewData, some of required attributes are not set " + attributes;
        }
    }
}

