/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputBotInlineResult;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SendWebViewResultMessage;

public final class ImmutableSendWebViewResultMessage
implements SendWebViewResultMessage {
    private final int identifier;
    private final String botQueryId;
    private final InputBotInlineResult result;

    private ImmutableSendWebViewResultMessage(String botQueryId, InputBotInlineResult result) {
        this.botQueryId = Objects.requireNonNull(botQueryId, "botQueryId");
        this.result = Objects.requireNonNull(result, "result");
        this.identifier = SendWebViewResultMessage.super.identifier();
    }

    private ImmutableSendWebViewResultMessage(Builder builder) {
        this.botQueryId = builder.botQueryId;
        this.result = builder.result;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendWebViewResultMessage.super.identifier();
    }

    private ImmutableSendWebViewResultMessage(int identifier, String botQueryId, InputBotInlineResult result) {
        this.identifier = identifier;
        this.botQueryId = botQueryId;
        this.result = result;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String botQueryId() {
        return this.botQueryId;
    }

    @Override
    public InputBotInlineResult result() {
        return this.result;
    }

    public final ImmutableSendWebViewResultMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendWebViewResultMessage(value, this.botQueryId, this.result);
    }

    public final ImmutableSendWebViewResultMessage withBotQueryId(String value) {
        String newValue = Objects.requireNonNull(value, "botQueryId");
        if (this.botQueryId.equals(newValue)) {
            return this;
        }
        return new ImmutableSendWebViewResultMessage(this.identifier, newValue, this.result);
    }

    public final ImmutableSendWebViewResultMessage withResult(InputBotInlineResult value) {
        if (this.result == value) {
            return this;
        }
        InputBotInlineResult newValue = Objects.requireNonNull(value, "result");
        return new ImmutableSendWebViewResultMessage(this.identifier, this.botQueryId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendWebViewResultMessage && this.equalTo(0, (ImmutableSendWebViewResultMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendWebViewResultMessage another) {
        return this.identifier == another.identifier && this.botQueryId.equals(another.botQueryId) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.botQueryId.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "SendWebViewResultMessage{identifier=" + this.identifier + ", botQueryId=" + this.botQueryId + ", result=" + this.result + "}";
    }

    public static ImmutableSendWebViewResultMessage of(String botQueryId, InputBotInlineResult result) {
        return new ImmutableSendWebViewResultMessage(botQueryId, result);
    }

    public static ImmutableSendWebViewResultMessage copyOf(SendWebViewResultMessage instance) {
        if (instance instanceof ImmutableSendWebViewResultMessage) {
            return (ImmutableSendWebViewResultMessage)instance;
        }
        return ImmutableSendWebViewResultMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT_QUERY_ID = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String botQueryId;
        private InputBotInlineResult result;

        private Builder() {
        }

        public final Builder from(SendWebViewResultMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendWebViewResultMessage instance;
            long bits = 0L;
            if (object instanceof SendWebViewResultMessage) {
                instance = (SendWebViewResultMessage)object;
                this.result(instance.result());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botQueryId(instance.botQueryId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder botQueryId(String botQueryId) {
            this.botQueryId = Objects.requireNonNull(botQueryId, "botQueryId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(InputBotInlineResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSendWebViewResultMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendWebViewResultMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("botQueryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build SendWebViewResultMessage, some of required attributes are not set " + attributes;
        }
    }
}

