/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetBotCallbackAnswer;

public final class ImmutableSetBotCallbackAnswer
implements SetBotCallbackAnswer {
    private final int identifier;
    private final int flags;
    private final boolean alert;
    private final long queryId;
    @Nullable
    private final String message;
    @Nullable
    private final String url;
    private final int cacheTime;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetBotCallbackAnswer(long queryId, int cacheTime) {
        this.queryId = queryId;
        this.cacheTime = cacheTime;
        this.message = null;
        this.url = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.alert = this.initShim.alert();
        this.initShim = null;
    }

    private ImmutableSetBotCallbackAnswer(Builder builder) {
        this.queryId = builder.queryId;
        this.message = builder.message;
        this.url = builder.url;
        this.cacheTime = builder.cacheTime;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.alertIsSet()) {
            this.initShim.alert(builder.alert);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.alert = this.initShim.alert();
        this.initShim = null;
    }

    private ImmutableSetBotCallbackAnswer(int identifier, int flags, boolean alert, long queryId, @Nullable String message, @Nullable String url, int cacheTime) {
        this.identifier = identifier;
        this.flags = flags;
        this.alert = alert;
        this.queryId = queryId;
        this.message = message;
        this.url = url;
        this.cacheTime = cacheTime;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetBotCallbackAnswer.super.identifier();
    }

    private int flagsInitialize() {
        return SetBotCallbackAnswer.super.flags();
    }

    private boolean alertInitialize() {
        return SetBotCallbackAnswer.super.alert();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean alert() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alert() : this.alert;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    public int cacheTime() {
        return this.cacheTime;
    }

    public final ImmutableSetBotCallbackAnswer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(value, this.flags, this.alert, this.queryId, this.message, this.url, this.cacheTime);
    }

    public final ImmutableSetBotCallbackAnswer withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(this.identifier, value, this.alert, this.queryId, this.message, this.url, this.cacheTime);
    }

    public final ImmutableSetBotCallbackAnswer withAlert(boolean value) {
        if (this.alert == value) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(this.identifier, this.flags, value, this.queryId, this.message, this.url, this.cacheTime);
    }

    public final ImmutableSetBotCallbackAnswer withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(this.identifier, this.flags, this.alert, value, this.message, this.url, this.cacheTime);
    }

    public final ImmutableSetBotCallbackAnswer withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(this.identifier, this.flags, this.alert, this.queryId, value, this.url, this.cacheTime);
    }

    public final ImmutableSetBotCallbackAnswer withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(this.identifier, this.flags, this.alert, this.queryId, this.message, value, this.cacheTime);
    }

    public final ImmutableSetBotCallbackAnswer withCacheTime(int value) {
        if (this.cacheTime == value) {
            return this;
        }
        return new ImmutableSetBotCallbackAnswer(this.identifier, this.flags, this.alert, this.queryId, this.message, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetBotCallbackAnswer && this.equalTo(0, (ImmutableSetBotCallbackAnswer)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetBotCallbackAnswer another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.alert == another.alert && this.queryId == another.queryId && Objects.equals(this.message, another.message) && Objects.equals(this.url, another.url) && this.cacheTime == another.cacheTime;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.alert);
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + this.cacheTime;
        return h;
    }

    public String toString() {
        return "SetBotCallbackAnswer{identifier=" + this.identifier + ", flags=" + this.flags + ", alert=" + this.alert + ", queryId=" + this.queryId + ", message=" + this.message + ", url=" + this.url + ", cacheTime=" + this.cacheTime + "}";
    }

    public static ImmutableSetBotCallbackAnswer of(long queryId, int cacheTime) {
        return new ImmutableSetBotCallbackAnswer(queryId, cacheTime);
    }

    public static ImmutableSetBotCallbackAnswer copyOf(SetBotCallbackAnswer instance) {
        if (instance instanceof ImmutableSetBotCallbackAnswer) {
            return (ImmutableSetBotCallbackAnswer)instance;
        }
        return ImmutableSetBotCallbackAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_CACHE_TIME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ALERT = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean alert;
        private long queryId;
        private String message;
        private String url;
        private int cacheTime;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetBotCallbackAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetBotCallbackAnswer) {
                String urlValue;
                instance = (SetBotCallbackAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.alert(instance.alert());
                this.flags(instance.flags());
                String messageValue = instance.message();
                if (messageValue != null) {
                    this.message(messageValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                this.queryId(instance.queryId());
                this.cacheTime(instance.cacheTime());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder alert(boolean alert) {
            this.alert = alert;
            this.optBits |= 4L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder cacheTime(int cacheTime) {
            this.cacheTime = cacheTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetBotCallbackAnswer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetBotCallbackAnswer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean alertIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cacheTime");
            }
            return "Cannot build SetBotCallbackAnswer, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte alertBuildStage = 0;
        private boolean alert;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetBotCallbackAnswer.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetBotCallbackAnswer.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean alert() {
            if (this.alertBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alertBuildStage == 0) {
                this.alertBuildStage = (byte)-1;
                this.alert = ImmutableSetBotCallbackAnswer.this.alertInitialize();
                this.alertBuildStage = 1;
            }
            return this.alert;
        }

        void alert(boolean alert) {
            this.alert = alert;
            this.alertBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.alertBuildStage == -1) {
                attributes.add("alert");
            }
            return "Cannot build SetBotCallbackAnswer, attribute initializers form cycle " + attributes;
        }
    }
}

