/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ShippingOption;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetBotShippingResults;

public final class ImmutableSetBotShippingResults
implements SetBotShippingResults {
    private final int identifier;
    private final int flags;
    private final long queryId;
    @Nullable
    private final String error;
    @Nullable
    private final List<ShippingOption> shippingOptions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetBotShippingResults(long queryId) {
        this.queryId = queryId;
        this.error = null;
        this.shippingOptions = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSetBotShippingResults(Builder builder) {
        this.queryId = builder.queryId;
        this.error = builder.error;
        List<ShippingOption> list = this.shippingOptions = builder.shippingOptions == null ? null : ImmutableSetBotShippingResults.createUnmodifiableList(true, builder.shippingOptions);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSetBotShippingResults(int identifier, int flags, long queryId, @Nullable String error, @Nullable List<ShippingOption> shippingOptions) {
        this.identifier = identifier;
        this.flags = flags;
        this.queryId = queryId;
        this.error = error;
        this.shippingOptions = shippingOptions;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetBotShippingResults.super.identifier();
    }

    private int flagsInitialize() {
        return SetBotShippingResults.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    @Nullable
    public String error() {
        return this.error;
    }

    @Override
    @Nullable
    public List<ShippingOption> shippingOptions() {
        return this.shippingOptions;
    }

    public final ImmutableSetBotShippingResults withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetBotShippingResults(value, this.flags, this.queryId, this.error, this.shippingOptions);
    }

    public final ImmutableSetBotShippingResults withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetBotShippingResults(this.identifier, value, this.queryId, this.error, this.shippingOptions);
    }

    public final ImmutableSetBotShippingResults withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableSetBotShippingResults(this.identifier, this.flags, value, this.error, this.shippingOptions);
    }

    public final ImmutableSetBotShippingResults withError(@Nullable String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableSetBotShippingResults(this.identifier, this.flags, this.queryId, value, this.shippingOptions);
    }

    public final ImmutableSetBotShippingResults withShippingOptions(ShippingOption ... elements) {
        if (elements == null) {
            return new ImmutableSetBotShippingResults(this.identifier, this.flags, this.queryId, this.error, null);
        }
        List<ShippingOption> newValue = Arrays.asList(elements) == null ? null : ImmutableSetBotShippingResults.createUnmodifiableList(false, ImmutableSetBotShippingResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSetBotShippingResults(this.identifier, this.flags, this.queryId, this.error, newValue);
    }

    public final ImmutableSetBotShippingResults withShippingOptions(@Nullable Iterable<? extends ShippingOption> elements) {
        if (this.shippingOptions == elements) {
            return this;
        }
        List<ShippingOption> newValue = elements == null ? null : ImmutableSetBotShippingResults.createUnmodifiableList(false, ImmutableSetBotShippingResults.createSafeList(elements, true, false));
        return new ImmutableSetBotShippingResults(this.identifier, this.flags, this.queryId, this.error, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetBotShippingResults && this.equalTo(0, (ImmutableSetBotShippingResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetBotShippingResults another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.queryId == another.queryId && Objects.equals(this.error, another.error) && Objects.equals(this.shippingOptions, another.shippingOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.shippingOptions);
        return h;
    }

    public String toString() {
        return "SetBotShippingResults{identifier=" + this.identifier + ", flags=" + this.flags + ", queryId=" + this.queryId + ", error=" + this.error + ", shippingOptions=" + this.shippingOptions + "}";
    }

    public static ImmutableSetBotShippingResults of(long queryId) {
        return new ImmutableSetBotShippingResults(queryId);
    }

    public static ImmutableSetBotShippingResults copyOf(SetBotShippingResults instance) {
        if (instance instanceof ImmutableSetBotShippingResults) {
            return (ImmutableSetBotShippingResults)instance;
        }
        return ImmutableSetBotShippingResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private long queryId;
        private String error;
        private List<ShippingOption> shippingOptions = null;

        private Builder() {
        }

        public final Builder from(SetBotShippingResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetBotShippingResults instance;
            long bits = 0L;
            if (object instanceof SetBotShippingResults) {
                List<ShippingOption> shippingOptionsValue;
                String errorValue;
                instance = (SetBotShippingResults)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((errorValue = instance.error()) != null) {
                    this.error(errorValue);
                }
                if ((shippingOptionsValue = instance.shippingOptions()) != null) {
                    this.addAllShippingOptions(shippingOptionsValue);
                }
                this.queryId(instance.queryId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder addShippingOption(ShippingOption element) {
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            this.shippingOptions.add(Objects.requireNonNull(element, "shippingOptions element"));
            return this;
        }

        public final Builder addShippingOptions(ShippingOption ... elements) {
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            for (ShippingOption element : elements) {
                this.shippingOptions.add(Objects.requireNonNull(element, "shippingOptions element"));
            }
            return this;
        }

        public final Builder shippingOptions(@Nullable Iterable<? extends ShippingOption> elements) {
            if (elements == null) {
                this.shippingOptions = null;
                return this;
            }
            this.shippingOptions = new ArrayList<ShippingOption>();
            return this.addAllShippingOptions(elements);
        }

        public final Builder addAllShippingOptions(Iterable<? extends ShippingOption> elements) {
            Objects.requireNonNull(elements, "shippingOptions element");
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            for (ShippingOption shippingOption : elements) {
                this.shippingOptions.add(Objects.requireNonNull(shippingOption, "shippingOptions element"));
            }
            return this;
        }

        public ImmutableSetBotShippingResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetBotShippingResults(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            return "Cannot build SetBotShippingResults, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetBotShippingResults.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetBotShippingResults.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build SetBotShippingResults, attribute initializers form cycle " + attributes;
        }
    }
}

