/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetChatAvailableReactions;

public final class ImmutableSetChatAvailableReactions
implements SetChatAvailableReactions {
    private final int identifier;
    private final InputPeer peer;
    private final List<String> availableReactions;

    private ImmutableSetChatAvailableReactions(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.availableReactions = Collections.emptyList();
        this.identifier = SetChatAvailableReactions.super.identifier();
    }

    private ImmutableSetChatAvailableReactions(Builder builder) {
        this.peer = builder.peer;
        this.availableReactions = ImmutableSetChatAvailableReactions.createUnmodifiableList(true, builder.availableReactions);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetChatAvailableReactions.super.identifier();
    }

    private ImmutableSetChatAvailableReactions(int identifier, InputPeer peer, List<String> availableReactions) {
        this.identifier = identifier;
        this.peer = peer;
        this.availableReactions = availableReactions;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public List<String> availableReactions() {
        return this.availableReactions;
    }

    public final ImmutableSetChatAvailableReactions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetChatAvailableReactions(value, this.peer, this.availableReactions);
    }

    public final ImmutableSetChatAvailableReactions withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetChatAvailableReactions(this.identifier, newValue, this.availableReactions);
    }

    public final ImmutableSetChatAvailableReactions withAvailableReactions(String ... elements) {
        List<String> newValue = ImmutableSetChatAvailableReactions.createUnmodifiableList(false, ImmutableSetChatAvailableReactions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSetChatAvailableReactions(this.identifier, this.peer, newValue);
    }

    public final ImmutableSetChatAvailableReactions withAvailableReactions(Iterable<String> elements) {
        if (this.availableReactions == elements) {
            return this;
        }
        List<String> newValue = ImmutableSetChatAvailableReactions.createUnmodifiableList(false, ImmutableSetChatAvailableReactions.createSafeList(elements, true, false));
        return new ImmutableSetChatAvailableReactions(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetChatAvailableReactions && this.equalTo(0, (ImmutableSetChatAvailableReactions)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetChatAvailableReactions another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.availableReactions.equals(another.availableReactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.availableReactions.hashCode();
        return h;
    }

    public String toString() {
        return "SetChatAvailableReactions{identifier=" + this.identifier + ", peer=" + this.peer + ", availableReactions=" + this.availableReactions + "}";
    }

    public static ImmutableSetChatAvailableReactions of(InputPeer peer) {
        return new ImmutableSetChatAvailableReactions(peer);
    }

    public static ImmutableSetChatAvailableReactions copyOf(SetChatAvailableReactions instance) {
        if (instance instanceof ImmutableSetChatAvailableReactions) {
            return (ImmutableSetChatAvailableReactions)instance;
        }
        return ImmutableSetChatAvailableReactions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private List<String> availableReactions = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(SetChatAvailableReactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetChatAvailableReactions instance;
            long bits = 0L;
            if (object instanceof SetChatAvailableReactions) {
                instance = (SetChatAvailableReactions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.addAllAvailableReactions(instance.availableReactions());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAvailableReaction(String element) {
            this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            return this;
        }

        public final Builder addAvailableReactions(String ... elements) {
            for (String element : elements) {
                this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            }
            return this;
        }

        public final Builder availableReactions(Iterable<String> elements) {
            this.availableReactions.clear();
            return this.addAllAvailableReactions(elements);
        }

        public final Builder addAllAvailableReactions(Iterable<String> elements) {
            for (String element : elements) {
                this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            }
            return this;
        }

        public ImmutableSetChatAvailableReactions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetChatAvailableReactions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build SetChatAvailableReactions, some of required attributes are not set " + attributes;
        }
    }
}

