/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetChatTheme;

public final class ImmutableSetChatTheme
implements SetChatTheme {
    private final int identifier;
    private final InputPeer peer;
    private final String emoticon;

    private ImmutableSetChatTheme(InputPeer peer, String emoticon) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.identifier = SetChatTheme.super.identifier();
    }

    private ImmutableSetChatTheme(Builder builder) {
        this.peer = builder.peer;
        this.emoticon = builder.emoticon;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetChatTheme.super.identifier();
    }

    private ImmutableSetChatTheme(int identifier, InputPeer peer, String emoticon) {
        this.identifier = identifier;
        this.peer = peer;
        this.emoticon = emoticon;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    public final ImmutableSetChatTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetChatTheme(value, this.peer, this.emoticon);
    }

    public final ImmutableSetChatTheme withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetChatTheme(this.identifier, newValue, this.emoticon);
    }

    public final ImmutableSetChatTheme withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableSetChatTheme(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetChatTheme && this.equalTo(0, (ImmutableSetChatTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetChatTheme another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.emoticon.equals(another.emoticon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.emoticon.hashCode();
        return h;
    }

    public String toString() {
        return "SetChatTheme{identifier=" + this.identifier + ", peer=" + this.peer + ", emoticon=" + this.emoticon + "}";
    }

    public static ImmutableSetChatTheme of(InputPeer peer, String emoticon) {
        return new ImmutableSetChatTheme(peer, emoticon);
    }

    public static ImmutableSetChatTheme copyOf(SetChatTheme instance) {
        if (instance instanceof ImmutableSetChatTheme) {
            return (ImmutableSetChatTheme)instance;
        }
        return ImmutableSetChatTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_EMOTICON = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private String emoticon;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetChatTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetChatTheme) {
                instance = (SetChatTheme)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.emoticon(instance.emoticon());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetChatTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetChatTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build SetChatTheme, some of required attributes are not set " + attributes;
        }
    }
}

