/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetDefaultReaction;

public final class ImmutableSetDefaultReaction
implements SetDefaultReaction {
    private final int identifier;
    private final String reaction;

    private ImmutableSetDefaultReaction(String reaction) {
        this.reaction = Objects.requireNonNull(reaction, "reaction");
        this.identifier = SetDefaultReaction.super.identifier();
    }

    private ImmutableSetDefaultReaction(Builder builder) {
        this.reaction = builder.reaction;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetDefaultReaction.super.identifier();
    }

    private ImmutableSetDefaultReaction(int identifier, String reaction) {
        this.identifier = identifier;
        this.reaction = reaction;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String reaction() {
        return this.reaction;
    }

    public final ImmutableSetDefaultReaction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetDefaultReaction(value, this.reaction);
    }

    public final ImmutableSetDefaultReaction withReaction(String value) {
        String newValue = Objects.requireNonNull(value, "reaction");
        if (this.reaction.equals(newValue)) {
            return this;
        }
        return new ImmutableSetDefaultReaction(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetDefaultReaction && this.equalTo(0, (ImmutableSetDefaultReaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetDefaultReaction another) {
        return this.identifier == another.identifier && this.reaction.equals(another.reaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.reaction.hashCode();
        return h;
    }

    public String toString() {
        return "SetDefaultReaction{identifier=" + this.identifier + ", reaction=" + this.reaction + "}";
    }

    public static ImmutableSetDefaultReaction of(String reaction) {
        return new ImmutableSetDefaultReaction(reaction);
    }

    public static ImmutableSetDefaultReaction copyOf(SetDefaultReaction instance) {
        if (instance instanceof ImmutableSetDefaultReaction) {
            return (ImmutableSetDefaultReaction)instance;
        }
        return ImmutableSetDefaultReaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REACTION = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String reaction;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetDefaultReaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetDefaultReaction) {
                instance = (SetDefaultReaction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reaction(instance.reaction());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder reaction(String reaction) {
            this.reaction = Objects.requireNonNull(reaction, "reaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSetDefaultReaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetDefaultReaction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reaction");
            }
            return "Cannot build SetDefaultReaction, some of required attributes are not set " + attributes;
        }
    }
}

