/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetEncryptedTyping;

public final class ImmutableSetEncryptedTyping
implements SetEncryptedTyping {
    private final int identifier;
    private final InputEncryptedChat peer;
    private final boolean typing;

    private ImmutableSetEncryptedTyping(InputEncryptedChat peer, boolean typing) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.typing = typing;
        this.identifier = SetEncryptedTyping.super.identifier();
    }

    private ImmutableSetEncryptedTyping(Builder builder) {
        this.peer = builder.peer;
        this.typing = builder.typing;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetEncryptedTyping.super.identifier();
    }

    private ImmutableSetEncryptedTyping(int identifier, InputEncryptedChat peer, boolean typing) {
        this.identifier = identifier;
        this.peer = peer;
        this.typing = typing;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    @Override
    public boolean typing() {
        return this.typing;
    }

    public final ImmutableSetEncryptedTyping withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetEncryptedTyping(value, this.peer, this.typing);
    }

    public final ImmutableSetEncryptedTyping withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetEncryptedTyping(this.identifier, newValue, this.typing);
    }

    public final ImmutableSetEncryptedTyping withTyping(boolean value) {
        if (this.typing == value) {
            return this;
        }
        return new ImmutableSetEncryptedTyping(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetEncryptedTyping && this.equalTo(0, (ImmutableSetEncryptedTyping)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetEncryptedTyping another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.typing == another.typing;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Boolean.hashCode(this.typing);
        return h;
    }

    public String toString() {
        return "SetEncryptedTyping{identifier=" + this.identifier + ", peer=" + this.peer + ", typing=" + this.typing + "}";
    }

    public static ImmutableSetEncryptedTyping of(InputEncryptedChat peer, boolean typing) {
        return new ImmutableSetEncryptedTyping(peer, typing);
    }

    public static ImmutableSetEncryptedTyping copyOf(SetEncryptedTyping instance) {
        if (instance instanceof ImmutableSetEncryptedTyping) {
            return (ImmutableSetEncryptedTyping)instance;
        }
        return ImmutableSetEncryptedTyping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_TYPING = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputEncryptedChat peer;
        private boolean typing;

        private Builder() {
        }

        public final Builder from(SetEncryptedTyping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetEncryptedTyping instance;
            long bits = 0L;
            if (object instanceof SetEncryptedTyping) {
                instance = (SetEncryptedTyping)object;
                this.typing(instance.typing());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder typing(boolean typing) {
            this.typing = typing;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetEncryptedTyping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetEncryptedTyping(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("typing");
            }
            return "Cannot build SetEncryptedTyping, some of required attributes are not set " + attributes;
        }
    }
}

