/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetGameScore;

public final class ImmutableSetGameScore
implements SetGameScore {
    private final int identifier;
    private final int flags;
    private final boolean editMessage;
    private final boolean force;
    private final InputPeer peer;
    private final int id;
    private final InputUser userId;
    private final int score;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetGameScore(InputPeer peer, int id, InputUser userId, int score) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.userId = Objects.requireNonNull(userId, "userId");
        this.score = score;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.editMessage = this.initShim.editMessage();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableSetGameScore(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        this.userId = builder.userId;
        this.score = builder.score;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.editMessageIsSet()) {
            this.initShim.editMessage(builder.editMessage);
        }
        if (builder.forceIsSet()) {
            this.initShim.force(builder.force);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.editMessage = this.initShim.editMessage();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableSetGameScore(int identifier, int flags, boolean editMessage, boolean force, InputPeer peer, int id, InputUser userId, int score) {
        this.identifier = identifier;
        this.flags = flags;
        this.editMessage = editMessage;
        this.force = force;
        this.peer = peer;
        this.id = id;
        this.userId = userId;
        this.score = score;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetGameScore.super.identifier();
    }

    private int flagsInitialize() {
        return SetGameScore.super.flags();
    }

    private boolean editMessageInitialize() {
        return SetGameScore.super.editMessage();
    }

    private boolean forceInitialize() {
        return SetGameScore.super.force();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean editMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.editMessage() : this.editMessage;
    }

    @Override
    public boolean force() {
        InitShim shim = this.initShim;
        return shim != null ? shim.force() : this.force;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public int score() {
        return this.score;
    }

    public final ImmutableSetGameScore withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetGameScore(value, this.flags, this.editMessage, this.force, this.peer, this.id, this.userId, this.score);
    }

    public final ImmutableSetGameScore withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetGameScore(this.identifier, value, this.editMessage, this.force, this.peer, this.id, this.userId, this.score);
    }

    public final ImmutableSetGameScore withEditMessage(boolean value) {
        if (this.editMessage == value) {
            return this;
        }
        return new ImmutableSetGameScore(this.identifier, this.flags, value, this.force, this.peer, this.id, this.userId, this.score);
    }

    public final ImmutableSetGameScore withForce(boolean value) {
        if (this.force == value) {
            return this;
        }
        return new ImmutableSetGameScore(this.identifier, this.flags, this.editMessage, value, this.peer, this.id, this.userId, this.score);
    }

    public final ImmutableSetGameScore withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetGameScore(this.identifier, this.flags, this.editMessage, this.force, newValue, this.id, this.userId, this.score);
    }

    public final ImmutableSetGameScore withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableSetGameScore(this.identifier, this.flags, this.editMessage, this.force, this.peer, value, this.userId, this.score);
    }

    public final ImmutableSetGameScore withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableSetGameScore(this.identifier, this.flags, this.editMessage, this.force, this.peer, this.id, newValue, this.score);
    }

    public final ImmutableSetGameScore withScore(int value) {
        if (this.score == value) {
            return this;
        }
        return new ImmutableSetGameScore(this.identifier, this.flags, this.editMessage, this.force, this.peer, this.id, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetGameScore && this.equalTo(0, (ImmutableSetGameScore)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetGameScore another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.editMessage == another.editMessage && this.force == another.force && this.peer.equals(another.peer) && this.id == another.id && this.userId.equals(another.userId) && this.score == another.score;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.editMessage);
        h += (h << 5) + Boolean.hashCode(this.force);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.score;
        return h;
    }

    public String toString() {
        return "SetGameScore{identifier=" + this.identifier + ", flags=" + this.flags + ", editMessage=" + this.editMessage + ", force=" + this.force + ", peer=" + this.peer + ", id=" + this.id + ", userId=" + this.userId + ", score=" + this.score + "}";
    }

    public static ImmutableSetGameScore of(InputPeer peer, int id, InputUser userId, int score) {
        return new ImmutableSetGameScore(peer, id, userId, score);
    }

    public static ImmutableSetGameScore copyOf(SetGameScore instance) {
        if (instance instanceof ImmutableSetGameScore) {
            return (ImmutableSetGameScore)instance;
        }
        return ImmutableSetGameScore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long INIT_BIT_SCORE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_EDIT_MESSAGE = 4L;
        private static final long OPT_BIT_FORCE = 8L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean editMessage;
        private boolean force;
        private InputPeer peer;
        private int id;
        private InputUser userId;
        private int score;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetGameScore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetGameScore) {
                instance = (SetGameScore)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.score(instance.score());
                this.editMessage(instance.editMessage());
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.force(instance.force());
                this.id(instance.id());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder editMessage(boolean editMessage) {
            this.editMessage = editMessage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder force(boolean force) {
            this.force = force;
            this.optBits |= 8L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder score(int score) {
            this.score = score;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSetGameScore build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetGameScore(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean editMessageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean forceIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("score");
            }
            return "Cannot build SetGameScore, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte editMessageBuildStage = 0;
        private boolean editMessage;
        private byte forceBuildStage = 0;
        private boolean force;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetGameScore.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetGameScore.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean editMessage() {
            if (this.editMessageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.editMessageBuildStage == 0) {
                this.editMessageBuildStage = (byte)-1;
                this.editMessage = ImmutableSetGameScore.this.editMessageInitialize();
                this.editMessageBuildStage = 1;
            }
            return this.editMessage;
        }

        void editMessage(boolean editMessage) {
            this.editMessage = editMessage;
            this.editMessageBuildStage = 1;
        }

        boolean force() {
            if (this.forceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceBuildStage == 0) {
                this.forceBuildStage = (byte)-1;
                this.force = ImmutableSetGameScore.this.forceInitialize();
                this.forceBuildStage = 1;
            }
            return this.force;
        }

        void force(boolean force) {
            this.force = force;
            this.forceBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.editMessageBuildStage == -1) {
                attributes.add("editMessage");
            }
            if (this.forceBuildStage == -1) {
                attributes.add("force");
            }
            return "Cannot build SetGameScore, attribute initializers form cycle " + attributes;
        }
    }
}

