/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetHistoryTTL;

public final class ImmutableSetHistoryTTL
implements SetHistoryTTL {
    private final int identifier;
    private final InputPeer peer;
    private final int period;

    private ImmutableSetHistoryTTL(InputPeer peer, int period) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.period = period;
        this.identifier = SetHistoryTTL.super.identifier();
    }

    private ImmutableSetHistoryTTL(Builder builder) {
        this.peer = builder.peer;
        this.period = builder.period;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetHistoryTTL.super.identifier();
    }

    private ImmutableSetHistoryTTL(int identifier, InputPeer peer, int period) {
        this.identifier = identifier;
        this.peer = peer;
        this.period = period;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int period() {
        return this.period;
    }

    public final ImmutableSetHistoryTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetHistoryTTL(value, this.peer, this.period);
    }

    public final ImmutableSetHistoryTTL withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetHistoryTTL(this.identifier, newValue, this.period);
    }

    public final ImmutableSetHistoryTTL withPeriod(int value) {
        if (this.period == value) {
            return this;
        }
        return new ImmutableSetHistoryTTL(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetHistoryTTL && this.equalTo(0, (ImmutableSetHistoryTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetHistoryTTL another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.period == another.period;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.period;
        return h;
    }

    public String toString() {
        return "SetHistoryTTL{identifier=" + this.identifier + ", peer=" + this.peer + ", period=" + this.period + "}";
    }

    public static ImmutableSetHistoryTTL of(InputPeer peer, int period) {
        return new ImmutableSetHistoryTTL(peer, period);
    }

    public static ImmutableSetHistoryTTL copyOf(SetHistoryTTL instance) {
        if (instance instanceof ImmutableSetHistoryTTL) {
            return (ImmutableSetHistoryTTL)instance;
        }
        return ImmutableSetHistoryTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_PERIOD = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int period;

        private Builder() {
        }

        public final Builder from(SetHistoryTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetHistoryTTL instance;
            long bits = 0L;
            if (object instanceof SetHistoryTTL) {
                instance = (SetHistoryTTL)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.period(instance.period());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder period(int period) {
            this.period = period;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetHistoryTTL build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetHistoryTTL(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("period");
            }
            return "Cannot build SetHistoryTTL, some of required attributes are not set " + attributes;
        }
    }
}

