/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InlineBotSwitchPM;
import telegram4j.tl.InputBotInlineResult;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetInlineBotResults;

public final class ImmutableSetInlineBotResults
implements SetInlineBotResults {
    private final int identifier;
    private final int flags;
    private final boolean gallery;
    private final boolean isPrivate;
    private final long queryId;
    private final List<InputBotInlineResult> results;
    private final int cacheTime;
    @Nullable
    private final String nextOffset;
    @Nullable
    private final InlineBotSwitchPM switchPm;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetInlineBotResults(long queryId, int cacheTime) {
        this.queryId = queryId;
        this.cacheTime = cacheTime;
        this.results = Collections.emptyList();
        this.nextOffset = null;
        this.switchPm = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.gallery = this.initShim.gallery();
        this.isPrivate = this.initShim.isPrivate();
        this.initShim = null;
    }

    private ImmutableSetInlineBotResults(Builder builder) {
        this.queryId = builder.queryId;
        this.results = ImmutableSetInlineBotResults.createUnmodifiableList(true, builder.results);
        this.cacheTime = builder.cacheTime;
        this.nextOffset = builder.nextOffset;
        this.switchPm = builder.switchPm;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.galleryIsSet()) {
            this.initShim.gallery(builder.gallery);
        }
        if (builder.isPrivateIsSet()) {
            this.initShim.isPrivate(builder.isPrivate);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.gallery = this.initShim.gallery();
        this.isPrivate = this.initShim.isPrivate();
        this.initShim = null;
    }

    private ImmutableSetInlineBotResults(int identifier, int flags, boolean gallery, boolean isPrivate, long queryId, List<InputBotInlineResult> results, int cacheTime, @Nullable String nextOffset, @Nullable InlineBotSwitchPM switchPm) {
        this.identifier = identifier;
        this.flags = flags;
        this.gallery = gallery;
        this.isPrivate = isPrivate;
        this.queryId = queryId;
        this.results = results;
        this.cacheTime = cacheTime;
        this.nextOffset = nextOffset;
        this.switchPm = switchPm;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetInlineBotResults.super.identifier();
    }

    private int flagsInitialize() {
        return SetInlineBotResults.super.flags();
    }

    private boolean galleryInitialize() {
        return SetInlineBotResults.super.gallery();
    }

    private boolean isPrivateInitialize() {
        return SetInlineBotResults.super.isPrivate();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean gallery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gallery() : this.gallery;
    }

    @Override
    public boolean isPrivate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrivate() : this.isPrivate;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public List<InputBotInlineResult> results() {
        return this.results;
    }

    @Override
    public int cacheTime() {
        return this.cacheTime;
    }

    @Override
    @Nullable
    public String nextOffset() {
        return this.nextOffset;
    }

    @Override
    @Nullable
    public InlineBotSwitchPM switchPm() {
        return this.switchPm;
    }

    public final ImmutableSetInlineBotResults withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(value, this.flags, this.gallery, this.isPrivate, this.queryId, this.results, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, value, this.gallery, this.isPrivate, this.queryId, this.results, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withGallery(boolean value) {
        if (this.gallery == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, value, this.isPrivate, this.queryId, this.results, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withIsPrivate(boolean value) {
        if (this.isPrivate == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, value, this.queryId, this.results, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, this.isPrivate, value, this.results, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withResults(InputBotInlineResult ... elements) {
        List<InputBotInlineResult> newValue = ImmutableSetInlineBotResults.createUnmodifiableList(false, ImmutableSetInlineBotResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, this.isPrivate, this.queryId, newValue, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withResults(Iterable<? extends InputBotInlineResult> elements) {
        if (this.results == elements) {
            return this;
        }
        List<InputBotInlineResult> newValue = ImmutableSetInlineBotResults.createUnmodifiableList(false, ImmutableSetInlineBotResults.createSafeList(elements, true, false));
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, this.isPrivate, this.queryId, newValue, this.cacheTime, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withCacheTime(int value) {
        if (this.cacheTime == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, this.isPrivate, this.queryId, this.results, value, this.nextOffset, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withNextOffset(@Nullable String value) {
        if (Objects.equals(this.nextOffset, value)) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, this.isPrivate, this.queryId, this.results, this.cacheTime, value, this.switchPm);
    }

    public final ImmutableSetInlineBotResults withSwitchPm(@Nullable InlineBotSwitchPM value) {
        if (this.switchPm == value) {
            return this;
        }
        return new ImmutableSetInlineBotResults(this.identifier, this.flags, this.gallery, this.isPrivate, this.queryId, this.results, this.cacheTime, this.nextOffset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetInlineBotResults && this.equalTo(0, (ImmutableSetInlineBotResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetInlineBotResults another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.gallery == another.gallery && this.isPrivate == another.isPrivate && this.queryId == another.queryId && this.results.equals(another.results) && this.cacheTime == another.cacheTime && Objects.equals(this.nextOffset, another.nextOffset) && Objects.equals(this.switchPm, another.switchPm);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.gallery);
        h += (h << 5) + Boolean.hashCode(this.isPrivate);
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + this.results.hashCode();
        h += (h << 5) + this.cacheTime;
        h += (h << 5) + Objects.hashCode(this.nextOffset);
        h += (h << 5) + Objects.hashCode(this.switchPm);
        return h;
    }

    public String toString() {
        return "SetInlineBotResults{identifier=" + this.identifier + ", flags=" + this.flags + ", gallery=" + this.gallery + ", isPrivate=" + this.isPrivate + ", queryId=" + this.queryId + ", results=" + this.results + ", cacheTime=" + this.cacheTime + ", nextOffset=" + this.nextOffset + ", switchPm=" + this.switchPm + "}";
    }

    public static ImmutableSetInlineBotResults of(long queryId, int cacheTime) {
        return new ImmutableSetInlineBotResults(queryId, cacheTime);
    }

    public static ImmutableSetInlineBotResults copyOf(SetInlineBotResults instance) {
        if (instance instanceof ImmutableSetInlineBotResults) {
            return (ImmutableSetInlineBotResults)instance;
        }
        return ImmutableSetInlineBotResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_CACHE_TIME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_GALLERY = 4L;
        private static final long OPT_BIT_IS_PRIVATE = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean gallery;
        private boolean isPrivate;
        private long queryId;
        private List<InputBotInlineResult> results = new ArrayList<InputBotInlineResult>();
        private int cacheTime;
        private String nextOffset;
        private InlineBotSwitchPM switchPm;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetInlineBotResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetInlineBotResults) {
                String nextOffsetValue;
                instance = (SetInlineBotResults)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.isPrivate(instance.isPrivate());
                InlineBotSwitchPM switchPmValue = instance.switchPm();
                if (switchPmValue != null) {
                    this.switchPm(switchPmValue);
                }
                if ((nextOffsetValue = instance.nextOffset()) != null) {
                    this.nextOffset(nextOffsetValue);
                }
                this.addAllResults(instance.results());
                this.gallery(instance.gallery());
                this.queryId(instance.queryId());
                this.cacheTime(instance.cacheTime());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder gallery(boolean gallery) {
            this.gallery = gallery;
            this.optBits |= 4L;
            return this;
        }

        public final Builder isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.optBits |= 8L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addResult(InputBotInlineResult element) {
            this.results.add(Objects.requireNonNull(element, "results element"));
            return this;
        }

        public final Builder addResults(InputBotInlineResult ... elements) {
            for (InputBotInlineResult element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            return this;
        }

        public final Builder results(Iterable<? extends InputBotInlineResult> elements) {
            this.results.clear();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends InputBotInlineResult> elements) {
            for (InputBotInlineResult inputBotInlineResult : elements) {
                this.results.add(Objects.requireNonNull(inputBotInlineResult, "results element"));
            }
            return this;
        }

        public final Builder cacheTime(int cacheTime) {
            this.cacheTime = cacheTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nextOffset(@Nullable String nextOffset) {
            this.nextOffset = nextOffset;
            return this;
        }

        public final Builder switchPm(@Nullable InlineBotSwitchPM switchPm) {
            this.switchPm = switchPm;
            return this;
        }

        public ImmutableSetInlineBotResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetInlineBotResults(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean galleryIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean isPrivateIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cacheTime");
            }
            return "Cannot build SetInlineBotResults, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte galleryBuildStage = 0;
        private boolean gallery;
        private byte isPrivateBuildStage = 0;
        private boolean isPrivate;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetInlineBotResults.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetInlineBotResults.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean gallery() {
            if (this.galleryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.galleryBuildStage == 0) {
                this.galleryBuildStage = (byte)-1;
                this.gallery = ImmutableSetInlineBotResults.this.galleryInitialize();
                this.galleryBuildStage = 1;
            }
            return this.gallery;
        }

        void gallery(boolean gallery) {
            this.gallery = gallery;
            this.galleryBuildStage = 1;
        }

        boolean isPrivate() {
            if (this.isPrivateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrivateBuildStage == 0) {
                this.isPrivateBuildStage = (byte)-1;
                this.isPrivate = ImmutableSetInlineBotResults.this.isPrivateInitialize();
                this.isPrivateBuildStage = 1;
            }
            return this.isPrivate;
        }

        void isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.isPrivateBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.galleryBuildStage == -1) {
                attributes.add("gallery");
            }
            if (this.isPrivateBuildStage == -1) {
                attributes.add("isPrivate");
            }
            return "Cannot build SetInlineBotResults, attribute initializers form cycle " + attributes;
        }
    }
}

