/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetInlineGameScore;

public final class ImmutableSetInlineGameScore
implements SetInlineGameScore {
    private final int identifier;
    private final int flags;
    private final boolean editMessage;
    private final boolean force;
    private final InputBotInlineMessageID id;
    private final InputUser userId;
    private final int score;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetInlineGameScore(InputBotInlineMessageID id, InputUser userId, int score) {
        this.id = Objects.requireNonNull(id, "id");
        this.userId = Objects.requireNonNull(userId, "userId");
        this.score = score;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.editMessage = this.initShim.editMessage();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableSetInlineGameScore(Builder builder) {
        this.id = builder.id;
        this.userId = builder.userId;
        this.score = builder.score;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.editMessageIsSet()) {
            this.initShim.editMessage(builder.editMessage);
        }
        if (builder.forceIsSet()) {
            this.initShim.force(builder.force);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.editMessage = this.initShim.editMessage();
        this.force = this.initShim.force();
        this.initShim = null;
    }

    private ImmutableSetInlineGameScore(int identifier, int flags, boolean editMessage, boolean force, InputBotInlineMessageID id, InputUser userId, int score) {
        this.identifier = identifier;
        this.flags = flags;
        this.editMessage = editMessage;
        this.force = force;
        this.id = id;
        this.userId = userId;
        this.score = score;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetInlineGameScore.super.identifier();
    }

    private int flagsInitialize() {
        return SetInlineGameScore.super.flags();
    }

    private boolean editMessageInitialize() {
        return SetInlineGameScore.super.editMessage();
    }

    private boolean forceInitialize() {
        return SetInlineGameScore.super.force();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean editMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.editMessage() : this.editMessage;
    }

    @Override
    public boolean force() {
        InitShim shim = this.initShim;
        return shim != null ? shim.force() : this.force;
    }

    @Override
    public InputBotInlineMessageID id() {
        return this.id;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public int score() {
        return this.score;
    }

    public final ImmutableSetInlineGameScore withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetInlineGameScore(value, this.flags, this.editMessage, this.force, this.id, this.userId, this.score);
    }

    public final ImmutableSetInlineGameScore withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetInlineGameScore(this.identifier, value, this.editMessage, this.force, this.id, this.userId, this.score);
    }

    public final ImmutableSetInlineGameScore withEditMessage(boolean value) {
        if (this.editMessage == value) {
            return this;
        }
        return new ImmutableSetInlineGameScore(this.identifier, this.flags, value, this.force, this.id, this.userId, this.score);
    }

    public final ImmutableSetInlineGameScore withForce(boolean value) {
        if (this.force == value) {
            return this;
        }
        return new ImmutableSetInlineGameScore(this.identifier, this.flags, this.editMessage, value, this.id, this.userId, this.score);
    }

    public final ImmutableSetInlineGameScore withId(InputBotInlineMessageID value) {
        if (this.id == value) {
            return this;
        }
        InputBotInlineMessageID newValue = Objects.requireNonNull(value, "id");
        return new ImmutableSetInlineGameScore(this.identifier, this.flags, this.editMessage, this.force, newValue, this.userId, this.score);
    }

    public final ImmutableSetInlineGameScore withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableSetInlineGameScore(this.identifier, this.flags, this.editMessage, this.force, this.id, newValue, this.score);
    }

    public final ImmutableSetInlineGameScore withScore(int value) {
        if (this.score == value) {
            return this;
        }
        return new ImmutableSetInlineGameScore(this.identifier, this.flags, this.editMessage, this.force, this.id, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetInlineGameScore && this.equalTo(0, (ImmutableSetInlineGameScore)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetInlineGameScore another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.editMessage == another.editMessage && this.force == another.force && this.id.equals(another.id) && this.userId.equals(another.userId) && this.score == another.score;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.editMessage);
        h += (h << 5) + Boolean.hashCode(this.force);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.score;
        return h;
    }

    public String toString() {
        return "SetInlineGameScore{identifier=" + this.identifier + ", flags=" + this.flags + ", editMessage=" + this.editMessage + ", force=" + this.force + ", id=" + this.id + ", userId=" + this.userId + ", score=" + this.score + "}";
    }

    public static ImmutableSetInlineGameScore of(InputBotInlineMessageID id, InputUser userId, int score) {
        return new ImmutableSetInlineGameScore(id, userId, score);
    }

    public static ImmutableSetInlineGameScore copyOf(SetInlineGameScore instance) {
        if (instance instanceof ImmutableSetInlineGameScore) {
            return (ImmutableSetInlineGameScore)instance;
        }
        return ImmutableSetInlineGameScore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_SCORE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_EDIT_MESSAGE = 4L;
        private static final long OPT_BIT_FORCE = 8L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean editMessage;
        private boolean force;
        private InputBotInlineMessageID id;
        private InputUser userId;
        private int score;

        private Builder() {
        }

        public final Builder from(SetInlineGameScore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetInlineGameScore instance;
            long bits = 0L;
            if (object instanceof SetInlineGameScore) {
                instance = (SetInlineGameScore)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.score(instance.score());
                this.editMessage(instance.editMessage());
                this.flags(instance.flags());
                this.force(instance.force());
                this.id(instance.id());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder editMessage(boolean editMessage) {
            this.editMessage = editMessage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder force(boolean force) {
            this.force = force;
            this.optBits |= 8L;
            return this;
        }

        public final Builder id(InputBotInlineMessageID id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder score(int score) {
            this.score = score;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSetInlineGameScore build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetInlineGameScore(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean editMessageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean forceIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("score");
            }
            return "Cannot build SetInlineGameScore, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte editMessageBuildStage = 0;
        private boolean editMessage;
        private byte forceBuildStage = 0;
        private boolean force;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetInlineGameScore.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetInlineGameScore.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean editMessage() {
            if (this.editMessageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.editMessageBuildStage == 0) {
                this.editMessageBuildStage = (byte)-1;
                this.editMessage = ImmutableSetInlineGameScore.this.editMessageInitialize();
                this.editMessageBuildStage = 1;
            }
            return this.editMessage;
        }

        void editMessage(boolean editMessage) {
            this.editMessage = editMessage;
            this.editMessageBuildStage = 1;
        }

        boolean force() {
            if (this.forceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceBuildStage == 0) {
                this.forceBuildStage = (byte)-1;
                this.force = ImmutableSetInlineGameScore.this.forceInitialize();
                this.forceBuildStage = 1;
            }
            return this.force;
        }

        void force(boolean force) {
            this.force = force;
            this.forceBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.editMessageBuildStage == -1) {
                attributes.add("editMessage");
            }
            if (this.forceBuildStage == -1) {
                attributes.add("force");
            }
            return "Cannot build SetInlineGameScore, attribute initializers form cycle " + attributes;
        }
    }
}

