/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.SetTyping;

public final class ImmutableSetTyping
implements SetTyping {
    private final int identifier;
    private final int flags;
    private final InputPeer peer;
    @Nullable
    private final Integer topMsgId;
    private final SendMessageAction action;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetTyping(InputPeer peer, SendMessageAction action) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.action = Objects.requireNonNull(action, "action");
        this.topMsgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSetTyping(Builder builder) {
        this.peer = builder.peer;
        this.topMsgId = builder.topMsgId;
        this.action = builder.action;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSetTyping(int identifier, int flags, InputPeer peer, @Nullable Integer topMsgId, SendMessageAction action) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.topMsgId = topMsgId;
        this.action = action;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetTyping.super.identifier();
    }

    private int flagsInitialize() {
        return SetTyping.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer topMsgId() {
        return this.topMsgId;
    }

    @Override
    public SendMessageAction action() {
        return this.action;
    }

    public final ImmutableSetTyping withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetTyping(value, this.flags, this.peer, this.topMsgId, this.action);
    }

    public final ImmutableSetTyping withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetTyping(this.identifier, value, this.peer, this.topMsgId, this.action);
    }

    public final ImmutableSetTyping withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetTyping(this.identifier, this.flags, newValue, this.topMsgId, this.action);
    }

    public final ImmutableSetTyping withTopMsgId(@Nullable Integer value) {
        if (Objects.equals(this.topMsgId, value)) {
            return this;
        }
        return new ImmutableSetTyping(this.identifier, this.flags, this.peer, value, this.action);
    }

    public final ImmutableSetTyping withAction(SendMessageAction value) {
        if (this.action == value) {
            return this;
        }
        SendMessageAction newValue = Objects.requireNonNull(value, "action");
        return new ImmutableSetTyping(this.identifier, this.flags, this.peer, this.topMsgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetTyping && this.equalTo(0, (ImmutableSetTyping)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetTyping another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.peer.equals(another.peer) && Objects.equals(this.topMsgId, another.topMsgId) && this.action.equals(another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.topMsgId);
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        return "SetTyping{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", topMsgId=" + this.topMsgId + ", action=" + this.action + "}";
    }

    public static ImmutableSetTyping of(InputPeer peer, SendMessageAction action) {
        return new ImmutableSetTyping(peer, action);
    }

    public static ImmutableSetTyping copyOf(SetTyping instance) {
        if (instance instanceof ImmutableSetTyping) {
            return (ImmutableSetTyping)instance;
        }
        return ImmutableSetTyping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ACTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputPeer peer;
        private Integer topMsgId;
        private SendMessageAction action;

        private Builder() {
        }

        public final Builder from(SetTyping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetTyping instance;
            long bits = 0L;
            if (object instanceof SetTyping) {
                instance = (SetTyping)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.action(instance.action());
                Integer topMsgIdValue = instance.topMsgId();
                if (topMsgIdValue != null) {
                    this.topMsgId(topMsgIdValue);
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder topMsgId(@Nullable Integer topMsgId) {
            this.topMsgId = topMsgId;
            return this;
        }

        public final Builder action(SendMessageAction action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetTyping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetTyping(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build SetTyping, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetTyping.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetTyping.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build SetTyping, attribute initializers form cycle " + attributes;
        }
    }
}

