/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.StartBot;

public final class ImmutableStartBot
implements StartBot {
    private final int identifier;
    private final InputUser bot;
    private final InputPeer peer;
    private final long randomId;
    private final String startParam;

    private ImmutableStartBot(InputUser bot, InputPeer peer, long randomId, String startParam) {
        this.bot = Objects.requireNonNull(bot, "bot");
        this.peer = Objects.requireNonNull(peer, "peer");
        this.randomId = randomId;
        this.startParam = Objects.requireNonNull(startParam, "startParam");
        this.identifier = StartBot.super.identifier();
    }

    private ImmutableStartBot(Builder builder) {
        this.bot = builder.bot;
        this.peer = builder.peer;
        this.randomId = builder.randomId;
        this.startParam = builder.startParam;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StartBot.super.identifier();
    }

    private ImmutableStartBot(int identifier, InputUser bot, InputPeer peer, long randomId, String startParam) {
        this.identifier = identifier;
        this.bot = bot;
        this.peer = peer;
        this.randomId = randomId;
        this.startParam = startParam;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public String startParam() {
        return this.startParam;
    }

    public final ImmutableStartBot withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStartBot(value, this.bot, this.peer, this.randomId, this.startParam);
    }

    public final ImmutableStartBot withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableStartBot(this.identifier, newValue, this.peer, this.randomId, this.startParam);
    }

    public final ImmutableStartBot withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableStartBot(this.identifier, this.bot, newValue, this.randomId, this.startParam);
    }

    public final ImmutableStartBot withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableStartBot(this.identifier, this.bot, this.peer, value, this.startParam);
    }

    public final ImmutableStartBot withStartParam(String value) {
        String newValue = Objects.requireNonNull(value, "startParam");
        if (this.startParam.equals(newValue)) {
            return this;
        }
        return new ImmutableStartBot(this.identifier, this.bot, this.peer, this.randomId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStartBot && this.equalTo(0, (ImmutableStartBot)another);
    }

    private boolean equalTo(int synthetic, ImmutableStartBot another) {
        return this.identifier == another.identifier && this.bot.equals(another.bot) && this.peer.equals(another.peer) && this.randomId == another.randomId && this.startParam.equals(another.startParam);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + this.startParam.hashCode();
        return h;
    }

    public String toString() {
        return "StartBot{identifier=" + this.identifier + ", bot=" + this.bot + ", peer=" + this.peer + ", randomId=" + this.randomId + ", startParam=" + this.startParam + "}";
    }

    public static ImmutableStartBot of(InputUser bot, InputPeer peer, long randomId, String startParam) {
        return new ImmutableStartBot(bot, peer, randomId, startParam);
    }

    public static ImmutableStartBot copyOf(StartBot instance) {
        if (instance instanceof ImmutableStartBot) {
            return (ImmutableStartBot)instance;
        }
        return ImmutableStartBot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT = 1L;
        private static final long INIT_BIT_PEER = 2L;
        private static final long INIT_BIT_RANDOM_ID = 4L;
        private static final long INIT_BIT_START_PARAM = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputUser bot;
        private InputPeer peer;
        private long randomId;
        private String startParam;

        private Builder() {
        }

        public final Builder from(StartBot instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StartBot instance;
            long bits = 0L;
            if (object instanceof StartBot) {
                instance = (StartBot)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.startParam(instance.startParam());
                this.bot(instance.bot());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder startParam(String startParam) {
            this.startParam = Objects.requireNonNull(startParam, "startParam");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableStartBot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStartBot(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bot");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("startParam");
            }
            return "Cannot build StartBot, some of required attributes are not set " + attributes;
        }
    }
}

