/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.StartHistoryImport;

public final class ImmutableStartHistoryImport
implements StartHistoryImport {
    private final int identifier;
    private final InputPeer peer;
    private final long importId;

    private ImmutableStartHistoryImport(InputPeer peer, long importId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.importId = importId;
        this.identifier = StartHistoryImport.super.identifier();
    }

    private ImmutableStartHistoryImport(Builder builder) {
        this.peer = builder.peer;
        this.importId = builder.importId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StartHistoryImport.super.identifier();
    }

    private ImmutableStartHistoryImport(int identifier, InputPeer peer, long importId) {
        this.identifier = identifier;
        this.peer = peer;
        this.importId = importId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public long importId() {
        return this.importId;
    }

    public final ImmutableStartHistoryImport withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStartHistoryImport(value, this.peer, this.importId);
    }

    public final ImmutableStartHistoryImport withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableStartHistoryImport(this.identifier, newValue, this.importId);
    }

    public final ImmutableStartHistoryImport withImportId(long value) {
        if (this.importId == value) {
            return this;
        }
        return new ImmutableStartHistoryImport(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStartHistoryImport && this.equalTo(0, (ImmutableStartHistoryImport)another);
    }

    private boolean equalTo(int synthetic, ImmutableStartHistoryImport another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.importId == another.importId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.importId);
        return h;
    }

    public String toString() {
        return "StartHistoryImport{identifier=" + this.identifier + ", peer=" + this.peer + ", importId=" + this.importId + "}";
    }

    public static ImmutableStartHistoryImport of(InputPeer peer, long importId) {
        return new ImmutableStartHistoryImport(peer, importId);
    }

    public static ImmutableStartHistoryImport copyOf(StartHistoryImport instance) {
        if (instance instanceof ImmutableStartHistoryImport) {
            return (ImmutableStartHistoryImport)instance;
        }
        return ImmutableStartHistoryImport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_IMPORT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private long importId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StartHistoryImport instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StartHistoryImport) {
                instance = (StartHistoryImport)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.importId(instance.importId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder importId(long importId) {
            this.importId = importId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStartHistoryImport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStartHistoryImport(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("importId");
            }
            return "Cannot build StartHistoryImport, some of required attributes are not set " + attributes;
        }
    }
}

