/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ToggleBotInAttachMenu;

public final class ImmutableToggleBotInAttachMenu
implements ToggleBotInAttachMenu {
    private final int identifier;
    private final InputUser bot;
    private final boolean enabled;

    private ImmutableToggleBotInAttachMenu(InputUser bot, boolean enabled) {
        this.bot = Objects.requireNonNull(bot, "bot");
        this.enabled = enabled;
        this.identifier = ToggleBotInAttachMenu.super.identifier();
    }

    private ImmutableToggleBotInAttachMenu(Builder builder) {
        this.bot = builder.bot;
        this.enabled = builder.enabled;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ToggleBotInAttachMenu.super.identifier();
    }

    private ImmutableToggleBotInAttachMenu(int identifier, InputUser bot, boolean enabled) {
        this.identifier = identifier;
        this.bot = bot;
        this.enabled = enabled;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public final ImmutableToggleBotInAttachMenu withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleBotInAttachMenu(value, this.bot, this.enabled);
    }

    public final ImmutableToggleBotInAttachMenu withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableToggleBotInAttachMenu(this.identifier, newValue, this.enabled);
    }

    public final ImmutableToggleBotInAttachMenu withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableToggleBotInAttachMenu(this.identifier, this.bot, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleBotInAttachMenu && this.equalTo(0, (ImmutableToggleBotInAttachMenu)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleBotInAttachMenu another) {
        return this.identifier == another.identifier && this.bot.equals(another.bot) && this.enabled == another.enabled;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + Boolean.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return "ToggleBotInAttachMenu{identifier=" + this.identifier + ", bot=" + this.bot + ", enabled=" + this.enabled + "}";
    }

    public static ImmutableToggleBotInAttachMenu of(InputUser bot, boolean enabled) {
        return new ImmutableToggleBotInAttachMenu(bot, enabled);
    }

    public static ImmutableToggleBotInAttachMenu copyOf(ToggleBotInAttachMenu instance) {
        if (instance instanceof ImmutableToggleBotInAttachMenu) {
            return (ImmutableToggleBotInAttachMenu)instance;
        }
        return ImmutableToggleBotInAttachMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT = 1L;
        private static final long INIT_BIT_ENABLED = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputUser bot;
        private boolean enabled;

        private Builder() {
        }

        public final Builder from(ToggleBotInAttachMenu instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToggleBotInAttachMenu instance;
            long bits = 0L;
            if (object instanceof ToggleBotInAttachMenu) {
                instance = (ToggleBotInAttachMenu)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.bot(instance.bot());
                this.enabled(instance.enabled());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToggleBotInAttachMenu build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleBotInAttachMenu(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bot");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build ToggleBotInAttachMenu, some of required attributes are not set " + attributes;
        }
    }
}

