/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDialogPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ToggleDialogPin;

public final class ImmutableToggleDialogPin
implements ToggleDialogPin {
    private final int identifier;
    private final int flags;
    private final boolean pinned;
    private final InputDialogPeer peer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableToggleDialogPin(InputDialogPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.initShim = null;
    }

    private ImmutableToggleDialogPin(Builder builder) {
        this.peer = builder.peer;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pinnedIsSet()) {
            this.initShim.pinned(builder.pinned);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.initShim = null;
    }

    private ImmutableToggleDialogPin(int identifier, int flags, boolean pinned, InputDialogPeer peer) {
        this.identifier = identifier;
        this.flags = flags;
        this.pinned = pinned;
        this.peer = peer;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ToggleDialogPin.super.identifier();
    }

    private int flagsInitialize() {
        return ToggleDialogPin.super.flags();
    }

    private boolean pinnedInitialize() {
        return ToggleDialogPin.super.pinned();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pinned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pinned() : this.pinned;
    }

    @Override
    public InputDialogPeer peer() {
        return this.peer;
    }

    public final ImmutableToggleDialogPin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleDialogPin(value, this.flags, this.pinned, this.peer);
    }

    public final ImmutableToggleDialogPin withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableToggleDialogPin(this.identifier, value, this.pinned, this.peer);
    }

    public final ImmutableToggleDialogPin withPinned(boolean value) {
        if (this.pinned == value) {
            return this;
        }
        return new ImmutableToggleDialogPin(this.identifier, this.flags, value, this.peer);
    }

    public final ImmutableToggleDialogPin withPeer(InputDialogPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputDialogPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableToggleDialogPin(this.identifier, this.flags, this.pinned, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleDialogPin && this.equalTo(0, (ImmutableToggleDialogPin)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleDialogPin another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pinned == another.pinned && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pinned);
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ToggleDialogPin{identifier=" + this.identifier + ", flags=" + this.flags + ", pinned=" + this.pinned + ", peer=" + this.peer + "}";
    }

    public static ImmutableToggleDialogPin of(InputDialogPeer peer) {
        return new ImmutableToggleDialogPin(peer);
    }

    public static ImmutableToggleDialogPin copyOf(ToggleDialogPin instance) {
        if (instance instanceof ImmutableToggleDialogPin) {
            return (ImmutableToggleDialogPin)instance;
        }
        return ImmutableToggleDialogPin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PINNED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pinned;
        private InputDialogPeer peer;

        private Builder() {
        }

        public final Builder from(ToggleDialogPin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToggleDialogPin instance;
            long bits = 0L;
            if (object instanceof ToggleDialogPin) {
                instance = (ToggleDialogPin)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.pinned(instance.pinned());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pinned(boolean pinned) {
            this.pinned = pinned;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputDialogPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableToggleDialogPin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleDialogPin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pinnedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ToggleDialogPin, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pinnedBuildStage = 0;
        private boolean pinned;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableToggleDialogPin.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableToggleDialogPin.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pinned() {
            if (this.pinnedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pinnedBuildStage == 0) {
                this.pinnedBuildStage = (byte)-1;
                this.pinned = ImmutableToggleDialogPin.this.pinnedInitialize();
                this.pinnedBuildStage = 1;
            }
            return this.pinned;
        }

        void pinned(boolean pinned) {
            this.pinned = pinned;
            this.pinnedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pinnedBuildStage == -1) {
                attributes.add("pinned");
            }
            return "Cannot build ToggleDialogPin, attribute initializers form cycle " + attributes;
        }
    }
}

