/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ToggleStickerSets;

public final class ImmutableToggleStickerSets
implements ToggleStickerSets {
    private final int identifier;
    private final int flags;
    private final boolean uninstall;
    private final boolean archive;
    private final boolean unarchive;
    private final List<InputStickerSet> stickersets;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableToggleStickerSets(Builder builder) {
        this.stickersets = ImmutableToggleStickerSets.createUnmodifiableList(true, builder.stickersets);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.uninstallIsSet()) {
            this.initShim.uninstall(builder.uninstall);
        }
        if (builder.archiveIsSet()) {
            this.initShim.archive(builder.archive);
        }
        if (builder.unarchiveIsSet()) {
            this.initShim.unarchive(builder.unarchive);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.uninstall = this.initShim.uninstall();
        this.archive = this.initShim.archive();
        this.unarchive = this.initShim.unarchive();
        this.initShim = null;
    }

    private ImmutableToggleStickerSets(int identifier, int flags, boolean uninstall, boolean archive, boolean unarchive, List<InputStickerSet> stickersets) {
        this.identifier = identifier;
        this.flags = flags;
        this.uninstall = uninstall;
        this.archive = archive;
        this.unarchive = unarchive;
        this.stickersets = stickersets;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ToggleStickerSets.super.identifier();
    }

    private int flagsInitialize() {
        return ToggleStickerSets.super.flags();
    }

    private boolean uninstallInitialize() {
        return ToggleStickerSets.super.uninstall();
    }

    private boolean archiveInitialize() {
        return ToggleStickerSets.super.archive();
    }

    private boolean unarchiveInitialize() {
        return ToggleStickerSets.super.unarchive();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean uninstall() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uninstall() : this.uninstall;
    }

    @Override
    public boolean archive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.archive() : this.archive;
    }

    @Override
    public boolean unarchive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unarchive() : this.unarchive;
    }

    @Override
    public List<InputStickerSet> stickersets() {
        return this.stickersets;
    }

    public final ImmutableToggleStickerSets withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleStickerSets(value, this.flags, this.uninstall, this.archive, this.unarchive, this.stickersets);
    }

    public final ImmutableToggleStickerSets withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableToggleStickerSets(this.identifier, value, this.uninstall, this.archive, this.unarchive, this.stickersets);
    }

    public final ImmutableToggleStickerSets withUninstall(boolean value) {
        if (this.uninstall == value) {
            return this;
        }
        return new ImmutableToggleStickerSets(this.identifier, this.flags, value, this.archive, this.unarchive, this.stickersets);
    }

    public final ImmutableToggleStickerSets withArchive(boolean value) {
        if (this.archive == value) {
            return this;
        }
        return new ImmutableToggleStickerSets(this.identifier, this.flags, this.uninstall, value, this.unarchive, this.stickersets);
    }

    public final ImmutableToggleStickerSets withUnarchive(boolean value) {
        if (this.unarchive == value) {
            return this;
        }
        return new ImmutableToggleStickerSets(this.identifier, this.flags, this.uninstall, this.archive, value, this.stickersets);
    }

    public final ImmutableToggleStickerSets withStickersets(InputStickerSet ... elements) {
        List<InputStickerSet> newValue = ImmutableToggleStickerSets.createUnmodifiableList(false, ImmutableToggleStickerSets.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableToggleStickerSets(this.identifier, this.flags, this.uninstall, this.archive, this.unarchive, newValue);
    }

    public final ImmutableToggleStickerSets withStickersets(Iterable<? extends InputStickerSet> elements) {
        if (this.stickersets == elements) {
            return this;
        }
        List<InputStickerSet> newValue = ImmutableToggleStickerSets.createUnmodifiableList(false, ImmutableToggleStickerSets.createSafeList(elements, true, false));
        return new ImmutableToggleStickerSets(this.identifier, this.flags, this.uninstall, this.archive, this.unarchive, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleStickerSets && this.equalTo(0, (ImmutableToggleStickerSets)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleStickerSets another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.uninstall == another.uninstall && this.archive == another.archive && this.unarchive == another.unarchive && this.stickersets.equals(another.stickersets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.uninstall);
        h += (h << 5) + Boolean.hashCode(this.archive);
        h += (h << 5) + Boolean.hashCode(this.unarchive);
        h += (h << 5) + this.stickersets.hashCode();
        return h;
    }

    public String toString() {
        return "ToggleStickerSets{identifier=" + this.identifier + ", flags=" + this.flags + ", uninstall=" + this.uninstall + ", archive=" + this.archive + ", unarchive=" + this.unarchive + ", stickersets=" + this.stickersets + "}";
    }

    public static ImmutableToggleStickerSets copyOf(ToggleStickerSets instance) {
        if (instance instanceof ImmutableToggleStickerSets) {
            return (ImmutableToggleStickerSets)instance;
        }
        return ImmutableToggleStickerSets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_UNINSTALL = 4L;
        private static final long OPT_BIT_ARCHIVE = 8L;
        private static final long OPT_BIT_UNARCHIVE = 16L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean uninstall;
        private boolean archive;
        private boolean unarchive;
        private List<InputStickerSet> stickersets = new ArrayList<InputStickerSet>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToggleStickerSets instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ToggleStickerSets) {
                instance = (ToggleStickerSets)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.unarchive(instance.unarchive());
                this.archive(instance.archive());
                this.uninstall(instance.uninstall());
                this.addAllStickersets(instance.stickersets());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder uninstall(boolean uninstall) {
            this.uninstall = uninstall;
            this.optBits |= 4L;
            return this;
        }

        public final Builder archive(boolean archive) {
            this.archive = archive;
            this.optBits |= 8L;
            return this;
        }

        public final Builder unarchive(boolean unarchive) {
            this.unarchive = unarchive;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addStickerset(InputStickerSet element) {
            this.stickersets.add(Objects.requireNonNull(element, "stickersets element"));
            return this;
        }

        public final Builder addStickersets(InputStickerSet ... elements) {
            for (InputStickerSet element : elements) {
                this.stickersets.add(Objects.requireNonNull(element, "stickersets element"));
            }
            return this;
        }

        public final Builder stickersets(Iterable<? extends InputStickerSet> elements) {
            this.stickersets.clear();
            return this.addAllStickersets(elements);
        }

        public final Builder addAllStickersets(Iterable<? extends InputStickerSet> elements) {
            for (InputStickerSet inputStickerSet : elements) {
                this.stickersets.add(Objects.requireNonNull(inputStickerSet, "stickersets element"));
            }
            return this;
        }

        public ImmutableToggleStickerSets build() {
            return new ImmutableToggleStickerSets(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean uninstallIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean archiveIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean unarchiveIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte uninstallBuildStage = 0;
        private boolean uninstall;
        private byte archiveBuildStage = 0;
        private boolean archive;
        private byte unarchiveBuildStage = 0;
        private boolean unarchive;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableToggleStickerSets.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableToggleStickerSets.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean uninstall() {
            if (this.uninstallBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uninstallBuildStage == 0) {
                this.uninstallBuildStage = (byte)-1;
                this.uninstall = ImmutableToggleStickerSets.this.uninstallInitialize();
                this.uninstallBuildStage = 1;
            }
            return this.uninstall;
        }

        void uninstall(boolean uninstall) {
            this.uninstall = uninstall;
            this.uninstallBuildStage = 1;
        }

        boolean archive() {
            if (this.archiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.archiveBuildStage == 0) {
                this.archiveBuildStage = (byte)-1;
                this.archive = ImmutableToggleStickerSets.this.archiveInitialize();
                this.archiveBuildStage = 1;
            }
            return this.archive;
        }

        void archive(boolean archive) {
            this.archive = archive;
            this.archiveBuildStage = 1;
        }

        boolean unarchive() {
            if (this.unarchiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unarchiveBuildStage == 0) {
                this.unarchiveBuildStage = (byte)-1;
                this.unarchive = ImmutableToggleStickerSets.this.unarchiveInitialize();
                this.unarchiveBuildStage = 1;
            }
            return this.unarchive;
        }

        void unarchive(boolean unarchive) {
            this.unarchive = unarchive;
            this.unarchiveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.uninstallBuildStage == -1) {
                attributes.add("uninstall");
            }
            if (this.archiveBuildStage == -1) {
                attributes.add("archive");
            }
            if (this.unarchiveBuildStage == -1) {
                attributes.add("unarchive");
            }
            return "Cannot build ToggleStickerSets, attribute initializers form cycle " + attributes;
        }
    }
}

