/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.TranscribeAudio;

public final class ImmutableTranscribeAudio
implements TranscribeAudio {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;

    private ImmutableTranscribeAudio(InputPeer peer, int msgId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.identifier = TranscribeAudio.super.identifier();
    }

    private ImmutableTranscribeAudio(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TranscribeAudio.super.identifier();
    }

    private ImmutableTranscribeAudio(int identifier, InputPeer peer, int msgId) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    public final ImmutableTranscribeAudio withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTranscribeAudio(value, this.peer, this.msgId);
    }

    public final ImmutableTranscribeAudio withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableTranscribeAudio(this.identifier, newValue, this.msgId);
    }

    public final ImmutableTranscribeAudio withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableTranscribeAudio(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTranscribeAudio && this.equalTo(0, (ImmutableTranscribeAudio)another);
    }

    private boolean equalTo(int synthetic, ImmutableTranscribeAudio another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        return h;
    }

    public String toString() {
        return "TranscribeAudio{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + "}";
    }

    public static ImmutableTranscribeAudio of(InputPeer peer, int msgId) {
        return new ImmutableTranscribeAudio(peer, msgId);
    }

    public static ImmutableTranscribeAudio copyOf(TranscribeAudio instance) {
        if (instance instanceof ImmutableTranscribeAudio) {
            return (ImmutableTranscribeAudio)instance;
        }
        return ImmutableTranscribeAudio.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int msgId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TranscribeAudio instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TranscribeAudio) {
                instance = (TranscribeAudio)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTranscribeAudio build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTranscribeAudio(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build TranscribeAudio, some of required attributes are not set " + attributes;
        }
    }
}

