/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.TranslateText;

public final class ImmutableTranslateText
implements TranslateText {
    private final int identifier;
    private final int flags;
    @Nullable
    private final InputPeer peer;
    @Nullable
    private final Integer msgId;
    @Nullable
    private final String text;
    @Nullable
    private final String fromLang;
    private final String toLang;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTranslateText(String toLang) {
        this.toLang = Objects.requireNonNull(toLang, "toLang");
        this.peer = null;
        this.msgId = null;
        this.text = null;
        this.fromLang = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableTranslateText(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.text = builder.text;
        this.fromLang = builder.fromLang;
        this.toLang = builder.toLang;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableTranslateText(int identifier, int flags, @Nullable InputPeer peer, @Nullable Integer msgId, @Nullable String text, @Nullable String fromLang, String toLang) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.msgId = msgId;
        this.text = text;
        this.fromLang = fromLang;
        this.toLang = toLang;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return TranslateText.super.identifier();
    }

    private int flagsInitialize() {
        return TranslateText.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer msgId() {
        return this.msgId;
    }

    @Override
    @Nullable
    public String text() {
        return this.text;
    }

    @Override
    @Nullable
    public String fromLang() {
        return this.fromLang;
    }

    @Override
    public String toLang() {
        return this.toLang;
    }

    public final ImmutableTranslateText withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTranslateText(value, this.flags, this.peer, this.msgId, this.text, this.fromLang, this.toLang);
    }

    public final ImmutableTranslateText withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableTranslateText(this.identifier, value, this.peer, this.msgId, this.text, this.fromLang, this.toLang);
    }

    public final ImmutableTranslateText withPeer(@Nullable InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        return new ImmutableTranslateText(this.identifier, this.flags, value, this.msgId, this.text, this.fromLang, this.toLang);
    }

    public final ImmutableTranslateText withMsgId(@Nullable Integer value) {
        if (Objects.equals(this.msgId, value)) {
            return this;
        }
        return new ImmutableTranslateText(this.identifier, this.flags, this.peer, value, this.text, this.fromLang, this.toLang);
    }

    public final ImmutableTranslateText withText(@Nullable String value) {
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return new ImmutableTranslateText(this.identifier, this.flags, this.peer, this.msgId, value, this.fromLang, this.toLang);
    }

    public final ImmutableTranslateText withFromLang(@Nullable String value) {
        if (Objects.equals(this.fromLang, value)) {
            return this;
        }
        return new ImmutableTranslateText(this.identifier, this.flags, this.peer, this.msgId, this.text, value, this.toLang);
    }

    public final ImmutableTranslateText withToLang(String value) {
        String newValue = Objects.requireNonNull(value, "toLang");
        if (this.toLang.equals(newValue)) {
            return this;
        }
        return new ImmutableTranslateText(this.identifier, this.flags, this.peer, this.msgId, this.text, this.fromLang, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTranslateText && this.equalTo(0, (ImmutableTranslateText)another);
    }

    private boolean equalTo(int synthetic, ImmutableTranslateText another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.peer, another.peer) && Objects.equals(this.msgId, another.msgId) && Objects.equals(this.text, another.text) && Objects.equals(this.fromLang, another.fromLang) && this.toLang.equals(another.toLang);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.peer);
        h += (h << 5) + Objects.hashCode(this.msgId);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.fromLang);
        h += (h << 5) + this.toLang.hashCode();
        return h;
    }

    public String toString() {
        return "TranslateText{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", msgId=" + this.msgId + ", text=" + this.text + ", fromLang=" + this.fromLang + ", toLang=" + this.toLang + "}";
    }

    public static ImmutableTranslateText of(String toLang) {
        return new ImmutableTranslateText(toLang);
    }

    public static ImmutableTranslateText copyOf(TranslateText instance) {
        if (instance instanceof ImmutableTranslateText) {
            return (ImmutableTranslateText)instance;
        }
        return ImmutableTranslateText.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TO_LANG = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputPeer peer;
        private Integer msgId;
        private String text;
        private String fromLang;
        private String toLang;

        private Builder() {
        }

        public final Builder from(TranslateText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TranslateText instance;
            long bits = 0L;
            if (object instanceof TranslateText) {
                String textValue;
                InputPeer peerValue;
                String fromLangValue;
                instance = (TranslateText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((fromLangValue = instance.fromLang()) != null) {
                    this.fromLang(fromLangValue);
                }
                if ((peerValue = instance.peer()) != null) {
                    this.peer(peerValue);
                }
                this.flags(instance.flags());
                Integer msgIdValue = instance.msgId();
                if (msgIdValue != null) {
                    this.msgId(msgIdValue);
                }
                if ((textValue = instance.text()) != null) {
                    this.text(textValue);
                }
                this.toLang(instance.toLang());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(@Nullable InputPeer peer) {
            this.peer = peer;
            return this;
        }

        public final Builder msgId(@Nullable Integer msgId) {
            this.msgId = msgId;
            return this;
        }

        public final Builder text(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder fromLang(@Nullable String fromLang) {
            this.fromLang = fromLang;
            return this;
        }

        public final Builder toLang(String toLang) {
            this.toLang = Objects.requireNonNull(toLang, "toLang");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTranslateText build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTranslateText(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("toLang");
            }
            return "Cannot build TranslateText, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableTranslateText.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableTranslateText.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build TranslateText, attribute initializers form cycle " + attributes;
        }
    }
}

