/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.UninstallStickerSet;

public final class ImmutableUninstallStickerSet
implements UninstallStickerSet {
    private final int identifier;
    private final InputStickerSet stickerset;

    private ImmutableUninstallStickerSet(InputStickerSet stickerset) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.identifier = UninstallStickerSet.super.identifier();
    }

    private ImmutableUninstallStickerSet(Builder builder) {
        this.stickerset = builder.stickerset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UninstallStickerSet.super.identifier();
    }

    private ImmutableUninstallStickerSet(int identifier, InputStickerSet stickerset) {
        this.identifier = identifier;
        this.stickerset = stickerset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    public final ImmutableUninstallStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUninstallStickerSet(value, this.stickerset);
    }

    public final ImmutableUninstallStickerSet withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableUninstallStickerSet(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUninstallStickerSet && this.equalTo(0, (ImmutableUninstallStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableUninstallStickerSet another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        return h;
    }

    public String toString() {
        return "UninstallStickerSet{identifier=" + this.identifier + ", stickerset=" + this.stickerset + "}";
    }

    public static ImmutableUninstallStickerSet of(InputStickerSet stickerset) {
        return new ImmutableUninstallStickerSet(stickerset);
    }

    public static ImmutableUninstallStickerSet copyOf(UninstallStickerSet instance) {
        if (instance instanceof ImmutableUninstallStickerSet) {
            return (ImmutableUninstallStickerSet)instance;
        }
        return ImmutableUninstallStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UninstallStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UninstallStickerSet) {
                instance = (UninstallStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUninstallStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUninstallStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            return "Cannot build UninstallStickerSet, some of required attributes are not set " + attributes;
        }
    }
}

