/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DialogFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.UpdateDialogFilter;

public final class ImmutableUpdateDialogFilter
implements UpdateDialogFilter {
    private final int identifier;
    private final int flags;
    private final int id;
    @Nullable
    private final DialogFilter filter;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateDialogFilter(int id) {
        this.id = id;
        this.filter = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateDialogFilter(Builder builder) {
        this.id = builder.id;
        this.filter = builder.filter;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateDialogFilter(int identifier, int flags, int id, @Nullable DialogFilter filter) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.filter = filter;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateDialogFilter.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateDialogFilter.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @Nullable
    public DialogFilter filter() {
        return this.filter;
    }

    public final ImmutableUpdateDialogFilter withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDialogFilter(value, this.flags, this.id, this.filter);
    }

    public final ImmutableUpdateDialogFilter withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateDialogFilter(this.identifier, value, this.id, this.filter);
    }

    public final ImmutableUpdateDialogFilter withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdateDialogFilter(this.identifier, this.flags, value, this.filter);
    }

    public final ImmutableUpdateDialogFilter withFilter(@Nullable DialogFilter value) {
        if (this.filter == value) {
            return this;
        }
        return new ImmutableUpdateDialogFilter(this.identifier, this.flags, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDialogFilter && this.equalTo(0, (ImmutableUpdateDialogFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDialogFilter another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id == another.id && Objects.equals(this.filter, another.filter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.filter);
        return h;
    }

    public String toString() {
        return "UpdateDialogFilter{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", filter=" + this.filter + "}";
    }

    public static ImmutableUpdateDialogFilter of(int id) {
        return new ImmutableUpdateDialogFilter(id);
    }

    public static ImmutableUpdateDialogFilter copyOf(UpdateDialogFilter instance) {
        if (instance instanceof ImmutableUpdateDialogFilter) {
            return (ImmutableUpdateDialogFilter)instance;
        }
        return ImmutableUpdateDialogFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private int id;
        private DialogFilter filter;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateDialogFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateDialogFilter) {
                instance = (UpdateDialogFilter)object;
                DialogFilter filterValue = instance.filter();
                if (filterValue != null) {
                    this.filter(filterValue);
                }
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(@Nullable DialogFilter filter) {
            this.filter = filter;
            return this;
        }

        public ImmutableUpdateDialogFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateDialogFilter(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build UpdateDialogFilter, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateDialogFilter.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateDialogFilter.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateDialogFilter, attribute initializers form cycle " + attributes;
        }
    }
}

