/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.UpdatePinnedMessage;

public final class ImmutableUpdatePinnedMessage
implements UpdatePinnedMessage {
    private final int identifier;
    private final int flags;
    private final boolean silent;
    private final boolean unpin;
    private final boolean pmOneside;
    private final InputPeer peer;
    private final int id;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdatePinnedMessage(InputPeer peer, int id) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.unpin = this.initShim.unpin();
        this.pmOneside = this.initShim.pmOneside();
        this.initShim = null;
    }

    private ImmutableUpdatePinnedMessage(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.unpinIsSet()) {
            this.initShim.unpin(builder.unpin);
        }
        if (builder.pmOnesideIsSet()) {
            this.initShim.pmOneside(builder.pmOneside);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.unpin = this.initShim.unpin();
        this.pmOneside = this.initShim.pmOneside();
        this.initShim = null;
    }

    private ImmutableUpdatePinnedMessage(int identifier, int flags, boolean silent, boolean unpin, boolean pmOneside, InputPeer peer, int id) {
        this.identifier = identifier;
        this.flags = flags;
        this.silent = silent;
        this.unpin = unpin;
        this.pmOneside = pmOneside;
        this.peer = peer;
        this.id = id;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdatePinnedMessage.super.identifier();
    }

    private int flagsInitialize() {
        return UpdatePinnedMessage.super.flags();
    }

    private boolean silentInitialize() {
        return UpdatePinnedMessage.super.silent();
    }

    private boolean unpinInitialize() {
        return UpdatePinnedMessage.super.unpin();
    }

    private boolean pmOnesideInitialize() {
        return UpdatePinnedMessage.super.pmOneside();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean unpin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unpin() : this.unpin;
    }

    @Override
    public boolean pmOneside() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pmOneside() : this.pmOneside;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    public final ImmutableUpdatePinnedMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePinnedMessage(value, this.flags, this.silent, this.unpin, this.pmOneside, this.peer, this.id);
    }

    public final ImmutableUpdatePinnedMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdatePinnedMessage(this.identifier, value, this.silent, this.unpin, this.pmOneside, this.peer, this.id);
    }

    public final ImmutableUpdatePinnedMessage withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableUpdatePinnedMessage(this.identifier, this.flags, value, this.unpin, this.pmOneside, this.peer, this.id);
    }

    public final ImmutableUpdatePinnedMessage withUnpin(boolean value) {
        if (this.unpin == value) {
            return this;
        }
        return new ImmutableUpdatePinnedMessage(this.identifier, this.flags, this.silent, value, this.pmOneside, this.peer, this.id);
    }

    public final ImmutableUpdatePinnedMessage withPmOneside(boolean value) {
        if (this.pmOneside == value) {
            return this;
        }
        return new ImmutableUpdatePinnedMessage(this.identifier, this.flags, this.silent, this.unpin, value, this.peer, this.id);
    }

    public final ImmutableUpdatePinnedMessage withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdatePinnedMessage(this.identifier, this.flags, this.silent, this.unpin, this.pmOneside, newValue, this.id);
    }

    public final ImmutableUpdatePinnedMessage withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdatePinnedMessage(this.identifier, this.flags, this.silent, this.unpin, this.pmOneside, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePinnedMessage && this.equalTo(0, (ImmutableUpdatePinnedMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePinnedMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.silent == another.silent && this.unpin == another.unpin && this.pmOneside == another.pmOneside && this.peer.equals(another.peer) && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.unpin);
        h += (h << 5) + Boolean.hashCode(this.pmOneside);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        return h;
    }

    public String toString() {
        return "UpdatePinnedMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", silent=" + this.silent + ", unpin=" + this.unpin + ", pmOneside=" + this.pmOneside + ", peer=" + this.peer + ", id=" + this.id + "}";
    }

    public static ImmutableUpdatePinnedMessage of(InputPeer peer, int id) {
        return new ImmutableUpdatePinnedMessage(peer, id);
    }

    public static ImmutableUpdatePinnedMessage copyOf(UpdatePinnedMessage instance) {
        if (instance instanceof ImmutableUpdatePinnedMessage) {
            return (ImmutableUpdatePinnedMessage)instance;
        }
        return ImmutableUpdatePinnedMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SILENT = 4L;
        private static final long OPT_BIT_UNPIN = 8L;
        private static final long OPT_BIT_PM_ONESIDE = 16L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean silent;
        private boolean unpin;
        private boolean pmOneside;
        private InputPeer peer;
        private int id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdatePinnedMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdatePinnedMessage) {
                instance = (UpdatePinnedMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                this.peer(instance.peer());
                this.pmOneside(instance.pmOneside());
                this.flags(instance.flags());
                this.unpin(instance.unpin());
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder unpin(boolean unpin) {
            this.unpin = unpin;
            this.optBits |= 8L;
            return this;
        }

        public final Builder pmOneside(boolean pmOneside) {
            this.pmOneside = pmOneside;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdatePinnedMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePinnedMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean unpinIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean pmOnesideIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build UpdatePinnedMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte unpinBuildStage = 0;
        private boolean unpin;
        private byte pmOnesideBuildStage = 0;
        private boolean pmOneside;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdatePinnedMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdatePinnedMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableUpdatePinnedMessage.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean unpin() {
            if (this.unpinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unpinBuildStage == 0) {
                this.unpinBuildStage = (byte)-1;
                this.unpin = ImmutableUpdatePinnedMessage.this.unpinInitialize();
                this.unpinBuildStage = 1;
            }
            return this.unpin;
        }

        void unpin(boolean unpin) {
            this.unpin = unpin;
            this.unpinBuildStage = 1;
        }

        boolean pmOneside() {
            if (this.pmOnesideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pmOnesideBuildStage == 0) {
                this.pmOnesideBuildStage = (byte)-1;
                this.pmOneside = ImmutableUpdatePinnedMessage.this.pmOnesideInitialize();
                this.pmOnesideBuildStage = 1;
            }
            return this.pmOneside;
        }

        void pmOneside(boolean pmOneside) {
            this.pmOneside = pmOneside;
            this.pmOnesideBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.unpinBuildStage == -1) {
                attributes.add("unpin");
            }
            if (this.pmOnesideBuildStage == -1) {
                attributes.add("pmOneside");
            }
            return "Cannot build UpdatePinnedMessage, attribute initializers form cycle " + attributes;
        }
    }
}

